﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.ComponentModel;
using ListOfValues;

namespace LovDemo
{
    class DemoViewModel : INotifyPropertyChanged
    {
        // Data
        private string _name;
        private string _abbr;
        private string _capital;

        public string Name
        {
            get { return _name; }
            set { _name = value; NotifyPropertyChanged("Name"); }
        }

        public string Abbr
        {
            get { return _abbr; }
            set { _abbr = value; NotifyPropertyChanged("Abbr"); }
        }

        public string Capital
        {
            get { return _capital; }
            set { _capital = value; NotifyPropertyChanged("Capital"); }
        }

        // List of values
        private ListOfValuesViewModel _lov1 = new ListOfValuesViewModel();
        private ListOfValuesViewModel _lov2 = new ListOfValuesViewModel();

        public ListOfValuesViewModel LOV1 { get { return _lov1; } }
        public ListOfValuesViewModel LOV2 { get { return _lov2; } }

        public DemoViewModel()
        {
            string connectionString = "Data Source=xe;User Id=ora; Password=ora; Min Pool Size=1;";

            // Initialize list of values 1
            _lov1.Title = "US States";
            _lov1.AddColumn("Name");
            _lov1.AddColumn("Abbreviation");
            _lov1.AddColumn("Capital");
            _lov1.FilterColumn = "name";
            _lov1.AddReturnItem(this, "Name", 0);
            _lov1.AddReturnItem(this, "Capital", 2);
            _lov1.ConnectionString = connectionString;
            _lov1.Query = "SELECT name, abbr, capital FROM states";

            // Initialize list of values 2
            _lov2.Title = "US State Abbreviations";
            _lov2.AddColumn("Abbreviation");
            _lov2.AddColumn("Name");
            _lov2.FilterColumn = "abbr";
            _lov2.AddReturnItem(this, "Abbr", 0);
            _lov2.ConnectionString = connectionString;
            _lov2.Query = "SELECT abbr, name FROM states";
            _lov2.Show += new ShowHandler(ShowLOV2);

        }

        void ShowLOV2()
        {
            if(String.IsNullOrEmpty(Abbr))
                MessageBox.Show("Field is empty.", "Error", MessageBoxButton.OK, MessageBoxImage.Error);
            else
                ListOfValuesView.Show(LOV2, Abbr);
        }

        public event PropertyChangedEventHandler PropertyChanged;

        protected void NotifyPropertyChanged(string prop)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(prop));
            }
        }
    }
}
