﻿using System;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;

namespace ListOfValues
{
    public class ListOfValuesCommands
    {
        public static RoutedCommand Show = new RoutedCommand();

        static ListOfValuesCommands()
        {
            ListOfValuesCommands.Show.InputGestures.Add(new KeyGesture(Key.F9, ModifierKeys.None));
        }
    }

    public class ListOfValuesTextBox : TextBox
    {
        public ListOfValuesViewModel ViewModel { get; set; }

        public ListOfValuesTextBox()
        {
            // Bind methods with the Show command
            CommandBinding binding = new CommandBinding(ListOfValuesCommands.Show, ExecutedShow, CanExecuteShow);
            this.CommandBindings.Add(binding);
        }

        private void CanExecuteShow(object sender, CanExecuteRoutedEventArgs e)
        {
            e.CanExecute = true;
        }

        private void ExecutedShow(object sender, ExecutedRoutedEventArgs e)
        {
            if (ViewModel != null)
            {
                ShowHandler show = ViewModel.Show;

                // Invoke show handler if it is redefined
                if (show != null)
                {
                    // Delegated handler may expect to have up-to-date value in bound property, so update it
                    GetBindingExpression(TextBox.TextProperty).UpdateSource();

                    show();
                }
                // Invoke standard show dialog
                else
                    ListOfValuesView.Show(ViewModel, this.Text);

                e.Handled = true;
            }
        }
    }
}
