﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows;
using System.Windows.Input;
using System.Windows.Controls;
using System.Windows.Data;
using System.Data;

namespace ListOfValues
{
    public partial class ListOfValuesView : Window
    {
        public ListOfValuesView(ListOfValuesViewModel vm)
        {
            InitializeComponent();

            if (vm != null)
            {
                SetColumns(vm.Columns);
                DataContext = vm;
            }
        }

        // Set column headers and bindings
        public void SetColumns(List<string> columns)
        {
            int i = 0;
            foreach (string col in columns)
            {
                _gridView.Columns.Add(new GridViewColumn
                {
                    Header = col,
                    DisplayMemberBinding = new Binding(String.Format("[{0}]", i++)),
                    Width = double.NaN
                });
            }
        }

        // Show dialog to select a value from a list
        public static void Show(ListOfValuesViewModel vm, string currentValue)
        {
            if (vm == null)
                return;
            
            vm.Fill(currentValue);

            ListOfValuesView view = new ListOfValuesView(vm);
            view.ShowDialog();
        }

        private void ListView_MouseDoubleClick(object sender, MouseButtonEventArgs e)
        {
            ProcessSelection();
        }

        private void OKButton_Click(object sender, RoutedEventArgs e)
        {
            ProcessSelection();
        }

        // Process selection and close the dialog
        void ProcessSelection()
        {
            ListOfValuesViewModel vm = this.DataContext as ListOfValuesViewModel;

            if (vm != null && _listView.SelectedItem != null)
            {
                // Set selected iten in the view model
                vm.SetSelected(_listView.SelectedItem);
            }

            // Close the dialog
            this.DialogResult = true;
        }
    }
}
