﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Reflection;
using Oracle.DataAccess.Client;

namespace ListOfValues
{
    // Delegate to replace standard logic to show List of Values
    public delegate void ShowHandler();

    public class ListOfValuesViewModel
    {
        // List of Values window title
        public string Title { get; set; }

        // Column header list
        private List<string> _columns = new List<string>();

        public List<string> Columns
        {
            get { return _columns; }
        }

        public void AddColumn(string name)
        {
            _columns.Add(name);
        }

        public class ReturnItem
        {
            public object Object { get; set; }
            public string Property { get; set; }
            public int Index { get; set; }
        }

        // List of items to store selected values
        public List<ReturnItem> _returnItems = new List<ReturnItem>();

        public void AddReturnItem(object obj, string prop, int idx)
        {
            _returnItems.Add(new ReturnItem() { Object = obj, Property = prop, Index = idx });
        }
        
        // SQL query to populate the list of values
        public string Query { get; set; }

        // List of values as DataView
        private DataView _data = null;

        public DataView Data
        {
            set { _data = value; }
            get { return _data; }
        }

        // Delegate to replace standard logic to show List of Values
       public ShowHandler Show;

        // Filter column name
        public string FilterColumn { get; set; }

        // Filter for DataView
        public string Filter
        {
            set
            {
                if (_data != null)
                {
                    _data.RowFilter = FilterColumn + " LIKE '%" + value + "%'";
                }
            }
        }

        // Textbox value name used in a SQL query as parameter
        public string Parameter { get; set; }

        // Database connection string (use connection pooling)
        public string ConnectionString { get; set; }

        // Get list of values by executing the query
        // Do not cache results as the content can be changed
        public void Fill(string currentValue)
        {
            using (OracleConnection con = new OracleConnection(ConnectionString))
            {
                OracleCommand cmd = new OracleCommand(Query, con);
                cmd.BindByName = true;

                if (currentValue != null && currentValue.Length > 0 &&
                   Parameter != null && Parameter.Length > 0)
                {
                    cmd.Parameters.Add(Parameter, currentValue);
                }

                OracleDataAdapter da = new OracleDataAdapter(cmd);
                
                DataSet ds = new DataSet();
                da.Fill(ds);

                _data = new DataView(ds.Tables[0]);
            }
        }

        // Set selected item from view
        public void SetSelected(object selected)
        {
            DataRowView dr = selected as DataRowView;

            if (selected != null)
            {
                // Set values to each return item
                foreach (ReturnItem returnItem in _returnItems)
                {
                    Type type = returnItem.Object.GetType();
                    PropertyInfo info = type.GetProperty(returnItem.Property);

                    if(info != null)
                        info.SetValue(returnItem.Object, dr.Row.ItemArray[returnItem.Index].ToString(), null);
                }
            }
        }
    }
}
