/*
 * Decompiled with CFR 0.152.
 */
package com.sqlines.studio.model.filemanager.listener;

@FunctionalInterface
public interface RecentFileChangeListener {
    public void onChange(Change var1);

    public static final class Change {
        private ChangeType changeType;
        private String filePath;
        private int fileIndex;
        private int movedFrom;
        private int movedTo;

        Change(ChangeType changeType, String filePath, int fileIndex, int movedFrom, int movedTo) {
            this.changeType = changeType;
            this.filePath = filePath;
            this.fileIndex = fileIndex;
            this.movedFrom = movedFrom;
            this.movedTo = movedTo;
        }

        public static ChangeBuilder builder() {
            return new ChangeBuilder();
        }

        public ChangeType getChangeType() {
            return this.changeType;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public int getFileIndex() {
            return this.fileIndex;
        }

        public int getMovedFrom() {
            return this.movedFrom;
        }

        public int getMovedTo() {
            return this.movedTo;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Change)) {
                return false;
            }
            Change other = (Change)o;
            if (this.getFileIndex() != other.getFileIndex()) {
                return false;
            }
            if (this.getMovedFrom() != other.getMovedFrom()) {
                return false;
            }
            if (this.getMovedTo() != other.getMovedTo()) {
                return false;
            }
            ChangeType this$changeType = this.getChangeType();
            ChangeType other$changeType = other.getChangeType();
            if (this$changeType == null ? other$changeType != null : !((Object)((Object)this$changeType)).equals((Object)other$changeType)) {
                return false;
            }
            String this$filePath = this.getFilePath();
            String other$filePath = other.getFilePath();
            return !(this$filePath == null ? other$filePath != null : !this$filePath.equals(other$filePath));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getFileIndex();
            result = result * 59 + this.getMovedFrom();
            result = result * 59 + this.getMovedTo();
            ChangeType $changeType = this.getChangeType();
            result = result * 59 + ($changeType == null ? 43 : ((Object)((Object)$changeType)).hashCode());
            String $filePath = this.getFilePath();
            result = result * 59 + ($filePath == null ? 43 : $filePath.hashCode());
            return result;
        }

        public String toString() {
            return "RecentFileChangeListener.Change(changeType=" + this.getChangeType() + ", filePath=" + this.getFilePath() + ", fileIndex=" + this.getFileIndex() + ", movedFrom=" + this.getMovedFrom() + ", movedTo=" + this.getMovedTo() + ")";
        }

        public static class ChangeBuilder {
            private ChangeType changeType;
            private String filePath;
            private int fileIndex;
            private int movedFrom;
            private int movedTo;

            ChangeBuilder() {
            }

            public ChangeBuilder changeType(ChangeType changeType) {
                this.changeType = changeType;
                return this;
            }

            public ChangeBuilder filePath(String filePath) {
                this.filePath = filePath;
                return this;
            }

            public ChangeBuilder fileIndex(int fileIndex) {
                this.fileIndex = fileIndex;
                return this;
            }

            public ChangeBuilder movedFrom(int movedFrom) {
                this.movedFrom = movedFrom;
                return this;
            }

            public ChangeBuilder movedTo(int movedTo) {
                this.movedTo = movedTo;
                return this;
            }

            public Change build() {
                return new Change(this.changeType, this.filePath, this.fileIndex, this.movedFrom, this.movedTo);
            }

            public String toString() {
                return "RecentFileChangeListener.Change.ChangeBuilder(changeType=" + this.changeType + ", filePath=" + this.filePath + ", fileIndex=" + this.fileIndex + ", movedFrom=" + this.movedFrom + ", movedTo=" + this.movedTo + ")";
            }
        }

        public static enum ChangeType {
            FILE_ADDED,
            FILE_REMOVED,
            FILE_MOVED;

        }
    }
}

