/*
 * Decompiled with CFR 0.152.
 */
package com.sqlines.studio.model.license;

import com.sqlines.studio.model.license.License;
import com.sqlines.studio.model.license.exception.InvalidRegistrationDataException;
import com.sqlines.studio.model.license.exception.LicenseFileNotFoundException;
import com.sqlines.studio.model.license.exception.LicenseProcessException;
import com.sqlines.studio.model.license.listener.LicenseChangeListener;
import com.sqlines.studio.model.sqlines.SqlinesCmdArguments;
import com.sqlines.studio.model.sqlines.SqlinesRunner;
import com.sqlines.studio.util.file.FileCreator;
import com.sqlines.studio.util.file.FileDeleter;
import com.sqlines.studio.util.file.FileStatsProvider;
import com.sqlines.studio.util.file.FileWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LicenseFile
implements License {
    private static final Logger log = LogManager.getLogger(LicenseFile.class);
    private final SqlinesRunner sqlines;
    private final FileWriter fileWriter;
    private final FileCreator fileCreator;
    private final FileDeleter fileDeleter;
    private final FileStatsProvider fileStatsProvider;
    private final Supplier<String> licensePathSupplier;
    private final List<LicenseChangeListener> licenseListeners = new ArrayList<LicenseChangeListener>(5);
    private long lastModified;

    @Override
    public synchronized void check() {
        String path = this.getLicenseFilePath();
        long modified = this.fileStatsProvider.lastModified(path);
        if (this.lastModified != modified) {
            log.info("Noticed license file change");
            String info = "Changing license due to license file update: license file updated at " + LocalDateTime.ofInstant(Instant.ofEpochMilli(modified), TimeZone.getDefault().toZoneId());
            log.info(info);
            this.changeLicense(modified);
        }
    }

    private String getLicenseFilePath() {
        String path = this.licensePathSupplier.get();
        if (!this.fileStatsProvider.exists(path)) {
            throw new LicenseFileNotFoundException("File not found: " + path);
        }
        return path;
    }

    private void changeLicense(long lastModified) {
        boolean isActive = this.isActive();
        this.licenseListeners.forEach(license -> license.changed(isActive));
        this.lastModified = lastModified;
        log.info("License changed. Status: " + (isActive ? "Active" : "Not active"));
    }

    @Override
    public synchronized boolean isActive() {
        try {
            this.getLicenseFilePath();
            String logFilePath = this.createLogFile();
            SqlinesCmdArguments arguments = SqlinesCmdArguments.builder().logFilePath(logFilePath).isLicenseCheck(true).build();
            String output = this.sqlines.runAndWait(arguments);
            this.deleteLogFile(logFilePath);
            boolean active = !output.contains("FOR EVALUATION USE ONLY");
            log.info("License checked. Status: " + active);
            return active;
        }
        catch (Exception exc) {
            log.error("Cannot check license file: " + exc.getMessage());
            return false;
        }
    }

    private String createLogFile() {
        String path = "";
        try {
            path = this.fileCreator.createTmpFile("sqlines-log");
            log.info("Temporary log file created: " + path);
        }
        catch (Exception exc) {
            log.error("Cannot create temporary log file: " + exc.getMessage());
        }
        return path;
    }

    private void deleteLogFile(String path) {
        try {
            this.fileDeleter.delete(path);
            log.info("Log file deleted: " + path);
        }
        catch (Exception exc) {
            log.error("Cannot delete log file: " + exc.getMessage());
        }
    }

    @Override
    public synchronized void changeLicense(String regName, String regNumber) {
        String path = this.getLicenseFilePath();
        this.writeLicenseInfo(path, regName, regNumber);
        this.lastModified = this.fileStatsProvider.lastModified(path);
        if (!this.isActive()) {
            this.licenseListeners.forEach(license -> license.changed(false));
            throw new InvalidRegistrationDataException("Invalid registration data");
        }
        this.licenseListeners.forEach(license -> license.changed(true));
    }

    private void writeLicenseInfo(String path, String regName, String regNumber) {
        try {
            String info = "SQLines license file:\n\nRegistration Name: " + regName + "\nRegistration Number: " + regNumber;
            this.fileWriter.write(path, info);
            log.info("License registration data change");
        }
        catch (IOException exc) {
            throw new LicenseProcessException("Cant write to license file", exc);
        }
    }

    @Override
    public synchronized void addLicenseListener(LicenseChangeListener listener) {
        this.licenseListeners.add(listener);
    }

    public LicenseFile(SqlinesRunner sqlines, FileWriter fileWriter, FileCreator fileCreator, FileDeleter fileDeleter, FileStatsProvider fileStatsProvider, Supplier<String> licensePathSupplier) {
        this.sqlines = sqlines;
        this.fileWriter = fileWriter;
        this.fileCreator = fileCreator;
        this.fileDeleter = fileDeleter;
        this.fileStatsProvider = fileStatsProvider;
        this.licensePathSupplier = licensePathSupplier;
    }
}

