/*
 * Decompiled with CFR 0.152.
 */
package com.sqlines.studio.model.sqlines;

import java.util.Optional;
import java.util.stream.Stream;

public class SqlinesCmdArguments {
    private String sourceMode;
    private String targetMode;
    private String sourceFilePath;
    private String targetFilePath;
    private String logFilePath;
    private boolean isLicenseCheck;

    public String[] toArray() {
        return (String[])Stream.of(Optional.ofNullable(this.sourceMode).map(val -> "-s = " + val), Optional.ofNullable(this.targetMode).map(val -> "-t = " + val), Optional.ofNullable(this.sourceFilePath).map(val -> "-in = " + val), Optional.ofNullable(this.targetFilePath).map(val -> "-out = " + val), Optional.ofNullable(this.logFilePath).map(val -> "-log = " + val), Optional.of(true).map(bool -> this.isLicenseCheck ? "-?" : null)).filter(Optional::isPresent).map(Optional::get).toArray(String[]::new);
    }

    SqlinesCmdArguments(String sourceMode, String targetMode, String sourceFilePath, String targetFilePath, String logFilePath, boolean isLicenseCheck) {
        this.sourceMode = sourceMode;
        this.targetMode = targetMode;
        this.sourceFilePath = sourceFilePath;
        this.targetFilePath = targetFilePath;
        this.logFilePath = logFilePath;
        this.isLicenseCheck = isLicenseCheck;
    }

    public static SqlinesCmdArgumentsBuilder builder() {
        return new SqlinesCmdArgumentsBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SqlinesCmdArguments)) {
            return false;
        }
        SqlinesCmdArguments other = (SqlinesCmdArguments)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isLicenseCheck != other.isLicenseCheck) {
            return false;
        }
        String this$sourceMode = this.sourceMode;
        String other$sourceMode = other.sourceMode;
        if (this$sourceMode == null ? other$sourceMode != null : !this$sourceMode.equals(other$sourceMode)) {
            return false;
        }
        String this$targetMode = this.targetMode;
        String other$targetMode = other.targetMode;
        if (this$targetMode == null ? other$targetMode != null : !this$targetMode.equals(other$targetMode)) {
            return false;
        }
        String this$sourceFilePath = this.sourceFilePath;
        String other$sourceFilePath = other.sourceFilePath;
        if (this$sourceFilePath == null ? other$sourceFilePath != null : !this$sourceFilePath.equals(other$sourceFilePath)) {
            return false;
        }
        String this$targetFilePath = this.targetFilePath;
        String other$targetFilePath = other.targetFilePath;
        if (this$targetFilePath == null ? other$targetFilePath != null : !this$targetFilePath.equals(other$targetFilePath)) {
            return false;
        }
        String this$logFilePath = this.logFilePath;
        String other$logFilePath = other.logFilePath;
        return !(this$logFilePath == null ? other$logFilePath != null : !this$logFilePath.equals(other$logFilePath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SqlinesCmdArguments;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isLicenseCheck ? 79 : 97);
        String $sourceMode = this.sourceMode;
        result = result * 59 + ($sourceMode == null ? 43 : $sourceMode.hashCode());
        String $targetMode = this.targetMode;
        result = result * 59 + ($targetMode == null ? 43 : $targetMode.hashCode());
        String $sourceFilePath = this.sourceFilePath;
        result = result * 59 + ($sourceFilePath == null ? 43 : $sourceFilePath.hashCode());
        String $targetFilePath = this.targetFilePath;
        result = result * 59 + ($targetFilePath == null ? 43 : $targetFilePath.hashCode());
        String $logFilePath = this.logFilePath;
        result = result * 59 + ($logFilePath == null ? 43 : $logFilePath.hashCode());
        return result;
    }

    public String toString() {
        return "SqlinesCmdArguments(sourceMode=" + this.sourceMode + ", targetMode=" + this.targetMode + ", sourceFilePath=" + this.sourceFilePath + ", targetFilePath=" + this.targetFilePath + ", logFilePath=" + this.logFilePath + ", isLicenseCheck=" + this.isLicenseCheck + ")";
    }

    public static class SqlinesCmdArgumentsBuilder {
        private String sourceMode;
        private String targetMode;
        private String sourceFilePath;
        private String targetFilePath;
        private String logFilePath;
        private boolean isLicenseCheck;

        SqlinesCmdArgumentsBuilder() {
        }

        public SqlinesCmdArgumentsBuilder sourceMode(String sourceMode) {
            this.sourceMode = sourceMode;
            return this;
        }

        public SqlinesCmdArgumentsBuilder targetMode(String targetMode) {
            this.targetMode = targetMode;
            return this;
        }

        public SqlinesCmdArgumentsBuilder sourceFilePath(String sourceFilePath) {
            this.sourceFilePath = sourceFilePath;
            return this;
        }

        public SqlinesCmdArgumentsBuilder targetFilePath(String targetFilePath) {
            this.targetFilePath = targetFilePath;
            return this;
        }

        public SqlinesCmdArgumentsBuilder logFilePath(String logFilePath) {
            this.logFilePath = logFilePath;
            return this;
        }

        public SqlinesCmdArgumentsBuilder isLicenseCheck(boolean isLicenseCheck) {
            this.isLicenseCheck = isLicenseCheck;
            return this;
        }

        public SqlinesCmdArguments build() {
            return new SqlinesCmdArguments(this.sourceMode, this.targetMode, this.sourceFilePath, this.targetFilePath, this.logFilePath, this.isLicenseCheck);
        }

        public String toString() {
            return "SqlinesCmdArguments.SqlinesCmdArgumentsBuilder(sourceMode=" + this.sourceMode + ", targetMode=" + this.targetMode + ", sourceFilePath=" + this.sourceFilePath + ", targetFilePath=" + this.targetFilePath + ", logFilePath=" + this.logFilePath + ", isLicenseCheck=" + this.isLicenseCheck + ")";
        }
    }
}

