/*
 * Decompiled with CFR 0.152.
 */
package com.sqlines.studio.model.sqlines;

import com.sqlines.studio.model.sqlines.SqlinesCmdArguments;
import com.sqlines.studio.model.sqlines.SqlinesRunner;
import com.sqlines.studio.model.sqlines.ecxeption.SqlinesNotFoundException;
import com.sqlines.studio.model.sqlines.ecxeption.SqlinesRuntimeException;
import com.sqlines.studio.model.sqlines.process.ProcessStarter;
import com.sqlines.studio.util.file.FileStatsProvider;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SqlinesRunnerImp
implements SqlinesRunner {
    private static final Logger log = LogManager.getLogger(SqlinesRunnerImp.class);
    private final ProcessStarter processStarter;
    private final Supplier<String> pathSupplier;
    private final FileStatsProvider fileStatsProvider;

    @Override
    public String runAndWait(SqlinesCmdArguments arguments) {
        try {
            this.checkSqlinesExistence(this.pathSupplier.get());
            Object[] args = this.prepareCmdArgs(arguments);
            Process process = this.processStarter.start((String[])args);
            log.info("Running SQLines command-line with args: " + Arrays.toString(args));
            process.waitFor();
            log.info("SQLines command-line finished successfully");
            return new String(process.getInputStream().readAllBytes());
        }
        catch (SqlinesNotFoundException exc) {
            throw exc;
        }
        catch (InterruptedException exc) {
            Thread.currentThread().interrupt();
            String errorMsg = "Sqlines was interrupted";
            throw new SqlinesRuntimeException(errorMsg, exc);
        }
        catch (Exception exc) {
            String errorMsg = "SQLines command-line crashed: " + exc.getMessage();
            throw new SqlinesRuntimeException(errorMsg);
        }
    }

    private String[] prepareCmdArgs(SqlinesCmdArguments arguments) {
        Stream<String> processPath = Stream.of(this.pathSupplier.get());
        Stream<String> args = Arrays.stream(arguments.toArray());
        return (String[])Stream.concat(processPath, args).toArray(String[]::new);
    }

    private void checkSqlinesExistence(String path) {
        if (!this.fileStatsProvider.exists(path)) {
            String errorMsg = "SQLines command-line was not found: " + path;
            throw new SqlinesNotFoundException(errorMsg);
        }
    }

    public SqlinesRunnerImp(ProcessStarter processStarter, Supplier<String> pathSupplier, FileStatsProvider fileStatsProvider) {
        this.processStarter = processStarter;
        this.pathSupplier = pathSupplier;
        this.fileStatsProvider = fileStatsProvider;
    }
}

