/*
 * Decompiled with CFR 0.152.
 */
package com.sqlines.studio.presenter;

import com.sqlines.studio.model.converter.ConversionResult;
import com.sqlines.studio.model.converter.Converter;
import com.sqlines.studio.model.converter.ConverterParameters;
import com.sqlines.studio.model.filemanager.FileManager;
import com.sqlines.studio.model.filemanager.listener.FileChangeListener;
import com.sqlines.studio.model.filemanager.listener.RecentFileChangeListener;
import com.sqlines.studio.model.tabs.ObservableTabs;
import com.sqlines.studio.model.tabs.Tab;
import com.sqlines.studio.model.tabs.listener.TabIndexChangeListener;
import com.sqlines.studio.model.tabs.listener.TabTitleChangeListener;
import com.sqlines.studio.model.tabs.listener.TabsChangeListener;
import com.sqlines.studio.model.tabs.listener.TextChangeListener;
import com.sqlines.studio.properties.PropertiesManager;
import com.sqlines.studio.view.mainwindow.MainWindowView;
import com.sqlines.studio.view.mainwindow.event.RecentFileEvent;
import com.sqlines.studio.view.mainwindow.event.TabCloseEvent;
import com.sqlines.studio.view.mainwindow.listener.ModeChangeListener;
import java.awt.Desktop;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.IntConsumer;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MainWindowPresenter {
    private static final Logger log = LogManager.getLogger(MainWindowPresenter.class);
    private final ObservableTabs tabs;
    private final FileManager fileManager;
    private final Converter converter;
    private final MainWindowView view;
    private final TabsChangeListener modelTabsListener = this::modelTabsChanged;
    private final TabIndexChangeListener modelIndexListener = this::modelTabIndexChanged;
    private final TabTitleChangeListener modelTabTitleListener = this::modelTabTileChanged;
    private final com.sqlines.studio.model.tabs.listener.ModeChangeListener modelSourceModeListener = (newMode, tabIndex) -> this.modelSourceModeChanged(newMode);
    private final com.sqlines.studio.model.tabs.listener.ModeChangeListener modelTargetModeListener = (newMode, tabIndex) -> this.modelTargetModeChanged(newMode);
    private final TextChangeListener modelSourceTextListener = this::modelSourceTextChanged;
    private final TextChangeListener modelTargetTextListener = this::modelTargetTextChanged;
    private final ChangeListener<Number> viewTabIndexListener = (o, oldIndex, newIndex) -> this.viewTabIndexChanged(newIndex.intValue());
    private final com.sqlines.studio.view.mainwindow.listener.TabTitleChangeListener viewTabTitleListener = this::viewTabTitleChanged;
    private final ModeChangeListener viewSourceModeListener = this::viewSourceModeChanged;
    private final ModeChangeListener viewTargetModeListener = this::viewTargetModeChanged;
    private final com.sqlines.studio.view.mainwindow.listener.TextChangeListener viewSourceTextListener = this::viewSourceTextChanged;
    private final com.sqlines.studio.view.mainwindow.listener.TextChangeListener viewTargetTextListener = this::viewTargetTextChanged;

    public MainWindowPresenter(ObservableTabs tabs, FileManager fileManager, Converter converter, MainWindowView view) {
        this.tabs = tabs;
        this.fileManager = fileManager;
        this.converter = converter;
        this.view = view;
        this.initView();
        this.initHandlers();
        view.show();
    }

    private void modelTabsChanged(TabsChangeListener.Change change) {
        if (change.getChangeType() == TabsChangeListener.Change.ChangeType.TAB_ADDED) {
            this.view.openTab(change.getTabIndex());
            this.tabs.setCurrTabIndex(change.getTabIndex());
        } else if (change.getChangeType() == TabsChangeListener.Change.ChangeType.TAB_REMOVED) {
            this.view.closeTab(change.getTabIndex());
        }
    }

    private void modelTabIndexChanged(int newIndex) {
        Platform.runLater(() -> {
            this.setCurrIndexInView(newIndex);
            this.setSourceModeInView(((Tab)this.tabs.get(newIndex)).getSourceMode());
            this.setTargetModeInView(((Tab)this.tabs.get(newIndex)).getTargetMode());
            this.showFilePathInView(newIndex);
        });
    }

    private void setCurrIndexInView(int index) {
        this.view.removeTabSelectionListener(this.viewTabIndexListener);
        this.view.setCurrTabIndex(index);
        this.view.addTabSelectionListener(this.viewTabIndexListener);
    }

    private void setSourceModeInView(String mode) {
        this.view.removeSourceModeListener(this.viewSourceModeListener);
        this.view.setSourceMode(mode);
        this.view.addSourceModeListener(this.viewSourceModeListener);
    }

    private void setTargetModeInView(String mode) {
        this.view.removeTargetModeListener(this.viewTargetModeListener);
        this.view.setTargetMode(mode);
        this.view.addTargetModeListener(this.viewTargetModeListener);
    }

    private void showFilePathInView(int tabIndex) {
        MainWindowView.FieldInFocus inFocus2 = this.view.inFocus(tabIndex);
        if (inFocus2 == MainWindowView.FieldInFocus.SOURCE) {
            this.view.showFilePath(((Tab)this.tabs.get(tabIndex)).getSourceFilePath());
        } else if (inFocus2 == MainWindowView.FieldInFocus.TARGET) {
            this.view.showFilePath(((Tab)this.tabs.get(tabIndex)).getTargetFilePath());
        }
    }

    private void modelTabTileChanged(String newTitle, int tabIndex) {
        Platform.runLater(() -> {
            this.view.removeTabTitleListener(this.viewTabTitleListener);
            this.view.setTabTitle(newTitle, tabIndex);
            this.view.addTabTitleListener(this.viewTabTitleListener);
        });
    }

    private void modelSourceModeChanged(String newMode) {
        if (!newMode.equals("")) {
            Platform.runLater(() -> this.setSourceModeInView(newMode));
        }
    }

    private void modelTargetModeChanged(String newMode) {
        if (!newMode.equals("")) {
            Platform.runLater(() -> this.setTargetModeInView(newMode));
        }
    }

    private void modelSourceTextChanged(String newText, int tabIndex) {
        Platform.runLater(() -> {
            this.view.removeSourceTextListener(this.viewSourceTextListener);
            this.view.setSourceText(newText, tabIndex);
            this.view.addSourceTextListener(this.viewSourceTextListener);
        });
    }

    private void modelTargetTextChanged(String newText, int tabIndex) {
        Platform.runLater(() -> {
            this.view.removeTargetTextListener(this.viewTargetTextListener);
            this.view.setTargetText(newText, tabIndex);
            this.view.addTargetTextListener(this.viewTargetTextListener);
        });
    }

    private void viewTabIndexChanged(int newIndex) {
        String targetMode;
        this.setCurrIndexInModel(newIndex);
        this.showFilePathInView(newIndex);
        String sourceMode = ((Tab)this.tabs.get(newIndex)).getSourceMode();
        if (sourceMode != null) {
            this.modelSourceModeChanged(sourceMode);
        }
        if ((targetMode = ((Tab)this.tabs.get(newIndex)).getTargetMode()) != null) {
            this.modelTargetModeChanged(targetMode);
        }
    }

    private void setCurrIndexInModel(int index) {
        this.tabs.removeTabIndexListener(this.modelIndexListener);
        this.tabs.setCurrTabIndex(index);
        this.tabs.addTabIndexListener(this.modelIndexListener);
    }

    private void viewTabTitleChanged(String newTitle, int tabIndex) {
        ((Tab)this.tabs.get(tabIndex)).setTabTitle(newTitle);
    }

    private void viewSourceModeChanged(String newMode, int tabIndex) {
        ((Tab)this.tabs.get(tabIndex)).setSourceMode(newMode);
    }

    private void viewTargetModeChanged(String newMode, int tabIndex) {
        ((Tab)this.tabs.get(tabIndex)).setTargetMode(newMode);
    }

    private void viewSourceTextChanged(String newText, int tabIndex) {
        ((Tab)this.tabs.get(tabIndex)).setSourceText(newText);
    }

    private void viewTargetTextChanged(String newText, int tabIndex) {
        ((Tab)this.tabs.get(tabIndex)).setTargetText(newText);
    }

    private void initHandlers() {
        this.initFileManager();
        this.initTabsDataHandlers();
        this.initViewHandlers();
    }

    private void initFileManager() {
        this.fileManager.addRecentFileListener(this::modelRecentFilesChanged);
        this.fileManager.addFileChangeListener(this::modelFileChanged);
    }

    private void modelRecentFilesChanged(RecentFileChangeListener.Change change) {
        if (change.getChangeType() == RecentFileChangeListener.Change.ChangeType.FILE_ADDED) {
            Platform.runLater(() -> this.view.addRecentFile(change.getFilePath()));
        } else if (change.getChangeType() == RecentFileChangeListener.Change.ChangeType.FILE_MOVED) {
            String filePath = change.getFilePath();
            int movedTo = change.getMovedTo();
            Platform.runLater(() -> this.view.moveRecentFile(filePath, movedTo));
        }
    }

    private void modelFileChanged(FileChangeListener.Change change) {
        String filePath = change.getFilePath();
        if (change.getChangeType() == FileChangeListener.Change.ChangeType.FILE_UPDATED) {
            IntConsumer sourceUpdate = i -> {
                String data = this.fileManager.openFile(filePath);
                this.tabs.setSourceText(data, i);
            };
            IntConsumer targetUpdate = i -> {
                String data = this.fileManager.openFile(filePath);
                this.tabs.setTargetText(data, i);
            };
            this.updateTabs(filePath, sourceUpdate, targetUpdate);
        } else if (change.getChangeType() == FileChangeListener.Change.ChangeType.FILE_DELETED) {
            IntConsumer sourceUpdate = i -> this.tabs.setSourceFilePath("", i);
            IntConsumer targetUpdate = i -> this.tabs.setTargetFilePath("", i);
            this.updateTabs(filePath, sourceUpdate, targetUpdate);
        }
    }

    private void updateTabs(String filePath, IntConsumer sourceUpdate, IntConsumer targetUpdate) {
        for (int i = 0; i < this.tabs.size(); ++i) {
            String sourcePath = ((Tab)this.tabs.get(i)).getSourceFilePath();
            String targetPath = ((Tab)this.tabs.get(i)).getTargetFilePath();
            if (sourcePath.equals(filePath)) {
                sourceUpdate.accept(i);
                continue;
            }
            if (!targetPath.equals(filePath)) continue;
            targetUpdate.accept(i);
        }
    }

    private void initTabsDataHandlers() {
        this.tabs.addTabsListener(this.modelTabsListener);
        this.tabs.addTabIndexListener(this.modelIndexListener);
        this.tabs.addTabTitleListener(this.modelTabTitleListener);
        this.tabs.addSourceModeListener(this.modelSourceModeListener);
        this.tabs.addTargetModeListener(this.modelTargetModeListener);
        this.tabs.addSourceTextListener(this.modelSourceTextListener);
        this.tabs.addTargetTextListener(this.modelTargetTextListener);
        this.tabs.addSourceFilePathListener(this::modelSourcePathChanged);
        this.tabs.addTargetFilePathListener(this::modelTargetPathChanged);
    }

    private void modelSourcePathChanged(String newPath, int tabIndex) {
        MainWindowView.FieldInFocus inFocus2;
        if (tabIndex == this.tabs.getCurrTabIndex() && ((inFocus2 = this.view.inFocus(tabIndex)) == MainWindowView.FieldInFocus.SOURCE || inFocus2 == MainWindowView.FieldInFocus.NONE)) {
            Platform.runLater(() -> this.view.showFilePath(newPath));
        }
    }

    private void modelTargetPathChanged(String newPath, int tabIndex) {
        MainWindowView.FieldInFocus inFocus2;
        if (tabIndex == this.tabs.getCurrTabIndex() && ((inFocus2 = this.view.inFocus(tabIndex)) == MainWindowView.FieldInFocus.TARGET || inFocus2 == MainWindowView.FieldInFocus.NONE)) {
            Platform.runLater(() -> this.view.showFilePath(newPath));
        }
    }

    private void initViewHandlers() {
        this.view.addTabSelectionListener(this.viewTabIndexListener);
        this.view.addTabTitleListener(this.viewTabTitleListener);
        this.view.addSourceModeListener(this.viewSourceModeListener);
        this.view.addTargetModeListener(this.viewTargetModeListener);
        this.view.addSourceTextListener(this.viewSourceTextListener);
        this.view.addTargetTextListener(this.viewTargetTextListener);
        this.view.addFocusListener(this::viewFocusChanged);
        this.view.setOnDragAction(this::receiveDrag);
        this.view.setOnDropAction(this::receiveDrop);
        this.view.setOnNewTabAction(event -> this.openTabPressed());
        this.view.setOnCloseTabAction(this::closeTabPressed);
        this.view.setOnOpenFileAction(event -> this.openFilePressed());
        this.view.setOnRecentFileAction(this::openRecentFilePressed);
        this.view.setOnClearRecentAction(event -> this.clearRecentFilesPressed());
        this.view.setOnSaveFileAction(event -> this.saveFilePressed());
        this.view.setOnSaveAsAction(event -> this.saveFileAsPressed());
        this.view.setOnRunAction(event -> this.runConversionPressed());
        this.view.setOnOnlineHelpAction(event -> this.openOnlineHelpPressed());
        this.view.setOnOpenSiteAction(event -> this.openSitePressed());
    }

    private void viewFocusChanged(MainWindowView.FieldInFocus inFocus2, int tabIndex) {
        if (inFocus2 == MainWindowView.FieldInFocus.SOURCE) {
            this.view.showFilePath(((Tab)this.tabs.get(tabIndex)).getSourceFilePath());
        } else if (inFocus2 == MainWindowView.FieldInFocus.TARGET) {
            this.view.showFilePath(((Tab)this.tabs.get(tabIndex)).getTargetFilePath());
        }
    }

    private void receiveDrag(DragEvent dragEvent) {
        log.info("Drag received");
        Dragboard dragboard = dragEvent.getDragboard();
        if (!dragboard.hasFiles() || dragboard.getFiles().stream().allMatch(File::isDirectory)) {
            dragEvent.consume();
            log.info("Drag consumed");
        } else {
            dragEvent.acceptTransferModes(TransferMode.COPY);
            log.info("Drag accepted");
        }
    }

    private void receiveDrop(DragEvent dragEvent) {
        this.openFiles(dragEvent.getDragboard().getFiles());
    }

    private void openFiles(List<File> files) {
        try {
            log.info("Opening " + files.size() + " files");
            for (File file : files) {
                int currIndex = this.tabs.getCurrTabIndex();
                if (!((Tab)this.tabs.get(currIndex)).getSourceText().isEmpty()) {
                    this.tabs.add(++currIndex, new Tab());
                }
                String data = this.fileManager.openFile(file.getAbsolutePath());
                this.setLastOpenedDir(file);
                this.tabs.setSourceText(data, currIndex);
                this.tabs.setTabTitle(file.getName(), currIndex);
                this.tabs.setSourceFilePath(file.getAbsolutePath(), currIndex);
            }
            log.info(files.size() + " files opened: " + files);
        }
        catch (Exception exc) {
            this.view.showError("File opening error: ", exc.getMessage());
        }
    }

    private void setLastOpenedDir(File file) {
        String dir = file.getParentFile().getAbsolutePath();
        PropertiesManager.set("LAST_DIR", dir);
    }

    private void openTabPressed() {
        int nextIndex = this.tabs.getCurrTabIndex() + 1;
        this.tabs.removeTabsListener(this.modelTabsListener);
        this.tabs.add(nextIndex, new Tab());
        this.tabs.addTabsListener(this.modelTabsListener);
        this.view.openTab(nextIndex);
        ((Tab)this.tabs.get(nextIndex)).setSourceMode(this.view.getSourceMode());
        ((Tab)this.tabs.get(nextIndex)).setTargetMode(this.view.getTargetMode());
        ((Tab)this.tabs.get(nextIndex)).setTabTitle(this.view.getTabTitle(nextIndex));
        this.tabs.setCurrTabIndex(nextIndex);
        log.info("Tab opened. Index: " + nextIndex);
    }

    private void closeTabPressed(TabCloseEvent closeRequestEvent) {
        if (this.tabs.size() == 1) {
            return;
        }
        int tabIndex = closeRequestEvent.getTabIndex();
        this.fileManager.removeFile(((Tab)this.tabs.get(tabIndex)).getSourceFilePath());
        this.fileManager.removeFile(((Tab)this.tabs.get(tabIndex)).getTargetFilePath());
        this.tabs.removeTabsListener(this.modelTabsListener);
        this.tabs.remove(tabIndex);
        this.tabs.addTabsListener(this.modelTabsListener);
        this.view.closeTab(tabIndex);
        this.view.setCurrTabIndex(tabIndex != 0 ? tabIndex - 1 : tabIndex);
        log.info("Tab " + tabIndex + " closed");
    }

    private void openFilePressed() {
        Optional selectedFiles = this.getLastDir().flatMap(this.view::choseFilesToOpen).or(this.view::choseFilesToOpen);
        selectedFiles.ifPresentOrElse(files -> this.openFiles(new ArrayList<File>((Collection<File>)files)), () -> log.info("No files to open"));
    }

    private Optional<File> getLastDir() {
        String lastDir = PropertiesManager.get("LAST_DIR");
        return Optional.ofNullable(lastDir).flatMap(path -> path.equals("-") ? Optional.empty() : Optional.of(path)).flatMap(path -> new File((String)path).exists() ? Optional.of(path) : Optional.empty()).flatMap(path -> Optional.of(new File((String)path)));
    }

    private void openRecentFilePressed(RecentFileEvent recentFileEvent) {
        ArrayList<File> mutableList = new ArrayList<File>();
        File file = new File(recentFileEvent.getFilePath());
        mutableList.add(file);
        this.openFiles(mutableList);
    }

    private void clearRecentFilesPressed() {
        this.fileManager.clearRecentFiles();
        this.view.clearRecentFiles();
        log.info("Recent files cleared");
    }

    private void saveFilePressed() {
        int currIndex = this.tabs.getCurrTabIndex();
        MainWindowView.FieldInFocus inFocus2 = this.view.inFocus(currIndex);
        try {
            if (inFocus2 == MainWindowView.FieldInFocus.SOURCE) {
                this.saveSourceFile(currIndex);
            } else if (inFocus2 == MainWindowView.FieldInFocus.TARGET) {
                this.saveTargetFile(currIndex);
            }
        }
        catch (Exception exc) {
            log.error("Saving file: " + exc.getMessage());
            this.view.showError("Filesystem error", exc.getMessage());
        }
    }

    private void saveSourceFile(int tabIndex) {
        Tab tab = (Tab)this.tabs.get(tabIndex);
        if (tab.getSourceFilePath().isEmpty()) {
            this.saveFileAsPressed();
            return;
        }
        String path = tab.getSourceFilePath();
        String data = tab.getSourceText();
        this.fileManager.saveFile(path, data);
        log.info("Source file saved in tab " + tabIndex);
    }

    private void saveTargetFile(int tabIndex) {
        Tab tab = (Tab)this.tabs.get(tabIndex);
        if (tab.getTargetFilePath().isEmpty()) {
            this.saveFileAsPressed();
            return;
        }
        log.info("Saving target file in tab " + tabIndex);
        String path = tab.getTargetFilePath();
        String data = tab.getTargetText();
        this.fileManager.saveFile(path, data);
        log.info("Target file saved in tab " + tabIndex);
    }

    private void saveFileAsPressed() {
        int currIndex = this.tabs.getCurrTabIndex();
        MainWindowView.FieldInFocus inFocus2 = this.view.inFocus(currIndex);
        this.view.choseFileSavingLocation().ifPresent(path -> {
            try {
                if (inFocus2 == MainWindowView.FieldInFocus.SOURCE) {
                    this.saveSourceFileAs(currIndex, (String)path);
                } else if (inFocus2 == MainWindowView.FieldInFocus.TARGET) {
                    this.saveTargetFileAs(currIndex, (String)path);
                }
            }
            catch (Exception exc) {
                log.error("Saving file: " + exc.getMessage());
                this.view.showError("Filesystem error", exc.getMessage());
            }
        });
    }

    private void saveSourceFileAs(int tabIndex, String path) {
        log.info("Saving source file: " + path);
        String data = ((Tab)this.tabs.get(tabIndex)).getSourceText();
        this.fileManager.saveFileAs(path, data);
        this.tabs.setTabTitle(new File(path).getName(), tabIndex);
        this.tabs.setSourceFilePath(path, tabIndex);
        log.info("Source file saved: " + path);
    }

    private void saveTargetFileAs(int tabIndex, String path) {
        log.info("Saving target file: " + path);
        String data = ((Tab)this.tabs.get(tabIndex)).getTargetText();
        this.fileManager.saveFileAs(path, data);
        this.tabs.setTargetFilePath(path, tabIndex);
        log.info("Target file saved: " + path);
    }

    private void runConversionPressed() {
        int currIndex = this.tabs.getCurrTabIndex();
        try {
            log.info("Running conversion in tab " + currIndex);
            this.runConversion(currIndex);
            log.info("Conversion ended in tab " + currIndex);
        }
        catch (Exception exc) {
            this.showConversionError(currIndex, exc.getMessage());
        }
        finally {
            this.showConversionEnd(currIndex);
        }
    }

    private void runConversion(int tabIndex) {
        Tab tab = (Tab)this.tabs.get(tabIndex);
        if (!tab.getSourceFilePath().isEmpty()) {
            log.info("Saving source file in tab " + tabIndex);
            String path = tab.getSourceFilePath();
            String data = tab.getSourceText();
            this.fileManager.saveFile(path, data);
            log.info("Source file saved in tab " + tabIndex);
        }
        Platform.runLater(() -> this.view.showConversionStart(tabIndex));
        ConverterParameters parameters = this.buildParameters(tab);
        ConversionResult result = this.converter.run(parameters);
        this.tabs.setTargetText(result.getData(), tabIndex);
        this.tabs.setTargetFilePath(result.getFilePath(), tabIndex);
        this.fileManager.add(result.getFilePath());
    }

    private ConverterParameters buildParameters(Tab tab) {
        ConverterParameters.ConverterParametersBuilder parameters = ConverterParameters.builder().sourceMode(tab.getSourceMode()).targetMode(tab.getTargetMode()).targetFileName(tab.getTabTitle().trim().toLowerCase());
        String sourcePath = tab.getSourceFilePath();
        if (!sourcePath.isEmpty()) {
            return parameters.sourceFilePath(sourcePath).build();
        }
        String data = tab.getSourceText();
        return parameters.sourceData(data).build();
    }

    private void showConversionEnd(int tabIndex) {
        Platform.runLater(() -> this.view.showConversionEnd(tabIndex));
    }

    private void showConversionError(int tabIndex, String errorMsg) {
        String error = "Conversion error in tab " + (tabIndex + 1) + ".\n" + errorMsg;
        log.error(error);
        Platform.runLater(() -> this.view.showError("Conversion error", error));
    }

    private void openOnlineHelpPressed() {
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            try {
                Desktop.getDesktop().browse(new URI("https://www.sqlines.com/contact-us"));
                log.info("Online help https://www.sqlines.com/contact-us opened");
            }
            catch (Exception e) {
                log.error("Open online help: " + e.getMessage());
            }
        }
    }

    private void openSitePressed() {
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            try {
                Desktop.getDesktop().browse(new URI("https://www.sqlines.com"));
                log.info("Site https://www.sqlines.com opened");
            }
            catch (Exception e) {
                log.error("Open site: " + e.getMessage());
            }
        }
    }

    private void initView() {
        this.loadTabsData();
        this.checkFiles();
        this.loadRecentFiles();
    }

    private void loadTabsData() {
        try {
            int tabsNumber = this.tabs.size();
            if (tabsNumber == 0) {
                this.openTabPressed();
            } else {
                this.loaView();
            }
        }
        catch (Exception exc) {
            log.error("Loading tabs in view failed: " + exc.getMessage());
            this.resetModel();
        }
    }

    private void loaView() {
        int currIndex = this.tabs.getCurrTabIndex();
        String sourceMode = ((Tab)this.tabs.get(currIndex)).getSourceMode();
        String targetMode = ((Tab)this.tabs.get(currIndex)).getTargetMode();
        for (Tab tab : this.tabs) {
            int index = this.tabs.indexOf(tab);
            this.view.openTab(index);
            tab.setSourceMode(this.view.getSourceMode());
            tab.setTargetMode(this.view.getTargetMode());
            this.view.setTabTitle(tab.getTabTitle(), index);
            this.view.setSourceText(tab.getSourceText(), index);
            this.view.setTargetText(tab.getTargetText(), index);
            this.view.showFilePath(tab.getSourceFilePath());
        }
        this.view.setCurrTabIndex(currIndex);
        this.view.setSourceMode(sourceMode);
        this.view.setTargetMode(targetMode);
    }

    private void resetModel() {
        log.info("Setting default state");
        this.fileManager.removeAllFiles();
        this.fileManager.clearRecentFiles();
        this.tabs.clear();
        this.view.closeAllTabs();
        this.view.clearRecentFiles();
        this.openTabPressed();
    }

    private void checkFiles() {
        int tabsFiles = this.tabs.stream().mapToInt(tab -> {
            if (!tab.getSourceFilePath().isEmpty() && !tab.getTargetFilePath().isEmpty()) {
                return 2;
            }
            if (!tab.getSourceFilePath().isEmpty() || !tab.getTargetFilePath().isEmpty()) {
                return 1;
            }
            return 0;
        }).sum();
        int files = this.fileManager.countFiles();
        if (files < tabsFiles) {
            String errorMsg = "Invalid state: " + files + " files open in file manager, " + tabsFiles + " open in tabs";
            log.error(errorMsg);
            this.resetModel();
        }
    }

    private void loadRecentFiles() {
        try {
            for (int i = 0; i < this.fileManager.countRecentFiles(); ++i) {
                this.view.addRecentFile(this.fileManager.getRecentFile(i));
            }
        }
        catch (Exception exc) {
            log.error("Loading files in view failed: " + exc.getMessage());
            this.resetModel();
        }
    }
}

