/*
 * Decompiled with CFR 0.152.
 */
package com.sqlines.studio.view;

import com.sqlines.studio.resource.UIResource;
import com.sqlines.studio.view.AbstractWindow;
import javafx.geometry.Insets;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.ToolBar;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.stage.Modality;
import javafx.stage.StageStyle;

public class ErrorWindow
extends AbstractWindow {
    private final Text text = new Text();

    public ErrorWindow(UIResource errorIcon) {
        this.setUpScene(errorIcon.getUrl());
        this.setUpWindow();
    }

    private void setUpScene(String errorUrl) {
        Parent errorImageLayout = this.createErrorImageLayout(errorUrl);
        Parent textLayout = this.createTextLayout();
        Parent buttonLayout = this.createButtonlayout();
        Parent mainLayout = this.createMainLayout(errorImageLayout, textLayout, buttonLayout);
        this.setRoot(mainLayout);
    }

    private Parent createErrorImageLayout(String errorUrl) {
        ImageView image = new ImageView(new Image(errorUrl));
        image.setFitWidth(60.0);
        image.setFitHeight(60.0);
        HBox imageLayout = new HBox(image);
        imageLayout.setPadding(new Insets(15.0, 15.0, 15.0, 10.0));
        return imageLayout;
    }

    private Parent createTextLayout() {
        VBox textLayout = new VBox(this.text);
        textLayout.setSpacing(15.0);
        textLayout.setPadding(new Insets(30.0, 15.0, 15.0, 0.0));
        return textLayout;
    }

    private Parent createButtonlayout() {
        Button okButton = new Button("Ok");
        okButton.setOnAction(event -> this.close());
        HBox buttonLayout = new HBox(okButton);
        buttonLayout.setPadding(new Insets(0.0, 0.0, 0.0, 6.0));
        return buttonLayout;
    }

    private Parent createMainLayout(Parent errorImage, Parent textLayout, Parent buttonLayout) {
        BorderPane mainLayout = new BorderPane();
        mainLayout.setId("errorWindow");
        mainLayout.setLeft(errorImage);
        mainLayout.setCenter(textLayout);
        mainLayout.setBottom(new ToolBar(buttonLayout));
        return mainLayout;
    }

    private void setUpWindow() {
        this.initModality(Modality.APPLICATION_MODAL);
        this.initStyle(StageStyle.UTILITY);
        this.sizeToScene();
        this.setResizable(false);
    }

    public void setError(String title, String errorMsg) {
        this.setTitle(title);
        this.text.setText(errorMsg);
    }
}

