/*
 * Decompiled with CFR 0.152.
 */
package com.sqlines.studio.view.mainwindow;

import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ToolBar;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.text.Text;

public class MainStatusBar
extends HBox {
    private final Text filePath = new Text();
    private final Text lineColumnNumber = new Text();
    private final ToolBar rightToolBar = new ToolBar();
    private int currLineNumber = 1;
    private int currColumnNumber = 1;

    public MainStatusBar() {
        this.setUp();
        this.ignoreKeyEvents();
    }

    private void setUp() {
        this.setUpRightToolBar();
        ToolBar leftToolBar = this.createLeftToolBar();
        this.getChildren().addAll((Node[])new Node[]{leftToolBar, this.rightToolBar});
        MainStatusBar.setHgrow(leftToolBar, Priority.ALWAYS);
        MainStatusBar.setHgrow(this.rightToolBar, Priority.NEVER);
    }

    private void setUpRightToolBar() {
        this.rightToolBar.setId("statusBar");
        this.rightToolBar.getItems().add(this.lineColumnNumber);
    }

    private ToolBar createLeftToolBar() {
        ToolBar leftToolBar = new ToolBar();
        leftToolBar.setId("statusBar");
        leftToolBar.getItems().add(this.filePath);
        return leftToolBar;
    }

    private void ignoreKeyEvents() {
        this.addEventFilter(KeyEvent.ANY, keyEvent -> {
            if (keyEvent.getCode() == KeyCode.TAB || keyEvent.getCode() == KeyCode.RIGHT || keyEvent.getCode() == KeyCode.LEFT || keyEvent.getCode() == KeyCode.UP || keyEvent.getCode() == KeyCode.DOWN) {
                keyEvent.consume();
            }
        });
    }

    public void showLineColumnNumberArea(boolean show) {
        ObservableList<Node> children = this.getChildren();
        if (show && !children.contains(this.rightToolBar)) {
            children.add(this.rightToolBar);
        } else if (!show) {
            children.remove(this.rightToolBar);
        }
    }

    public void setFilePath(String path) {
        if (!path.isEmpty()) {
            this.filePath.setText("Source: " + path);
        } else {
            this.filePath.setText("Source: Editor");
        }
    }

    public void setLineNumber(int lineNumber) {
        String text = "Line: " + lineNumber + ", Column: " + this.currColumnNumber;
        this.lineColumnNumber.setText(text);
        this.currLineNumber = lineNumber;
    }

    public void setColumnNumber(int columnNumber) {
        String text = "Line: " + this.currLineNumber + ", Column: " + columnNumber;
        this.lineColumnNumber.setText(text);
        this.currColumnNumber = columnNumber;
    }
}

