/*
 * Decompiled with CFR 0.152.
 */
package com.sqlines.studio.view.mainwindow.editor;

import com.sqlines.studio.view.mainwindow.editor.EditorContextMenu;
import com.sqlines.studio.view.mainwindow.editor.Highlighter;
import com.sqlines.studio.view.mainwindow.editor.VisibleParagraphStyler;
import java.util.Collection;
import java.util.function.IntFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import org.fxmisc.flowless.VirtualizedScrollPane;
import org.fxmisc.richtext.CodeArea;
import org.fxmisc.richtext.LineNumberFactory;
import org.fxmisc.richtext.NavigationActions;

public class CodeEditor
extends VBox {
    private final CodeArea codeArea = new CodeArea();
    private final VirtualizedScrollPane<CodeArea> scrollPane = new VirtualizedScrollPane<CodeArea>(this.codeArea);
    private final VisibleParagraphStyler<Collection<String>, String, Collection<String>> styler;
    private LineNumbersPolicy lineNumbersPolicy = LineNumbersPolicy.SHOW;
    private HighlighterPolicy highlighterPolicy = HighlighterPolicy.HIGHLIGHT;
    private int fontSize = 13;

    public CodeEditor(Highlighter highlighter, EditorContextMenu contextMenu) {
        this.styler = new VisibleParagraphStyler<Collection<String>, String, Collection<String>>(this.codeArea, highlighter::computeHighlighting);
        this.setUpAutoIntent();
        this.setUpHighlighter();
        this.setUpScrollPane();
        this.setUpLineNumberArea();
        this.setUpContextMenu(contextMenu);
    }

    private void setUpAutoIntent() {
        Pattern whiteSpace = Pattern.compile("^\\s+");
        this.addEventHandler(KeyEvent.KEY_PRESSED, keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ENTER) {
                int caretPos = this.codeArea.getCaretPosition();
                int currParagraph = this.codeArea.getCurrentParagraph();
                String sequence = (String)this.codeArea.getParagraph(currParagraph - 1).getSegments().get(0);
                Matcher matcher = whiteSpace.matcher(sequence);
                if (matcher.find()) {
                    Platform.runLater(() -> this.codeArea.insertText(caretPos, matcher.group()));
                }
            }
        });
    }

    private void setUpHighlighter() {
        this.codeArea.getVisibleParagraphs().addModificationObserver(this.styler);
    }

    private void setUpScrollPane() {
        this.scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.scrollPane.setPrefWidth(8000.0);
        this.scrollPane.setPrefHeight(8000.0);
        this.getChildren().add(this.scrollPane);
    }

    private void setUpLineNumberArea() {
        IntFunction<Node> lineNumFactory = LineNumberFactory.get(this.codeArea);
        this.codeArea.setParagraphGraphicFactory(currLine -> {
            HBox layout = new HBox((Node)lineNumFactory.apply(currLine));
            layout.setPadding(new Insets(0.0, 35.0, 0.0, 0.0));
            return layout;
        });
    }

    private void setUpContextMenu(EditorContextMenu contextMenu) {
        this.setUpMenuEvents(contextMenu);
        this.codeArea.setContextMenu(contextMenu);
        this.codeArea.setOnContextMenuRequested(event -> {
            contextMenu.setUndoEnabled(this.codeArea.isUndoAvailable());
            contextMenu.setRedoEnabled(this.codeArea.isRedoAvailable());
        });
    }

    private void setUpMenuEvents(EditorContextMenu menu) {
        menu.setOnUndoAction(event -> this.codeArea.undo());
        menu.setOnRedoAction(event -> this.codeArea.redo());
        menu.setOnSelectAllAction(event -> this.codeArea.selectAll());
        menu.setOnCutAction(event -> this.codeArea.cut());
        menu.setOnCopyAction(event -> this.codeArea.copy());
        menu.setOnPasteAction(event -> this.codeArea.paste());
    }

    @Override
    public void requestFocus() {
        Platform.runLater(this.codeArea::requestFocus);
    }

    public boolean hasFocus() {
        return this.codeArea.isFocused();
    }

    public String getText() {
        return this.codeArea.getText();
    }

    public void setText(String text) {
        this.codeArea.replaceText(text);
        this.codeArea.moveTo(0, 0, NavigationActions.SelectionPolicy.CLEAR);
    }

    public int getLineIndex() {
        return this.codeArea.getCaretSelectionBind().paragraphIndexProperty().getValue();
    }

    public int getColumnIndex() {
        return this.codeArea.caretColumnProperty().getValue();
    }

    public void setWrappingPolicy(WrappingPolicy policy) {
        if (policy == WrappingPolicy.NO_WRAP) {
            this.disableWrapping();
        } else if (policy == WrappingPolicy.WRAP_LINES) {
            this.enableWrapping();
        }
    }

    private void disableWrapping() {
        this.codeArea.setWrapText(false);
        this.scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
    }

    private void enableWrapping() {
        this.codeArea.setWrapText(true);
        this.scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
    }

    public void setHighlighterPolicy(HighlighterPolicy policy) {
        if (this.highlighterPolicy == policy) {
            return;
        }
        this.highlighterPolicy = policy;
        if (policy == HighlighterPolicy.HIGHLIGHT) {
            this.setUpHighlighter();
        } else if (policy == HighlighterPolicy.DO_NOT_HIGHLIGHT) {
            this.removeHighlighter();
        }
    }

    private void removeHighlighter() {
        this.codeArea.getVisibleParagraphs().removeModificationObserver(this.styler);
        String currText = this.codeArea.getText();
        this.codeArea.replaceText(currText);
        this.codeArea.moveTo(0, 0, NavigationActions.SelectionPolicy.CLEAR);
    }

    public void setLineNumbersPolicy(LineNumbersPolicy policy) {
        if (this.lineNumbersPolicy == policy) {
            return;
        }
        this.lineNumbersPolicy = policy;
        if (policy == LineNumbersPolicy.SHOW) {
            this.setUpLineNumberArea();
        } else if (policy == LineNumbersPolicy.DO_NOT_SHOW) {
            this.removeLineNumberArea();
        }
    }

    private void removeLineNumberArea() {
        this.codeArea.setParagraphGraphicFactory(null);
    }

    public void undo() {
        this.codeArea.undo();
    }

    public void redo() {
        this.codeArea.redo();
    }

    public void selectAll() {
        this.codeArea.selectAll();
    }

    public void cut() {
        this.codeArea.cut();
    }

    public void copy() {
        this.codeArea.copy();
    }

    public void paste() {
        this.codeArea.paste();
    }

    public boolean isUndoAvailable() {
        return this.codeArea.isUndoAvailable();
    }

    public boolean isRedoAvailable() {
        return this.codeArea.isRedoAvailable();
    }

    public void zoomIn() {
        ++this.fontSize;
        this.codeArea.setStyle("-fx-font-size: " + this.fontSize + "px");
    }

    public void zoomOut() {
        --this.fontSize;
        this.codeArea.setStyle("-fx-font-size: " + this.fontSize + "px");
    }

    public void addTextListener(ChangeListener<String> listener) {
        this.codeArea.textProperty().addListener(listener);
    }

    public void addLineIndexListener(ChangeListener<Integer> listener) {
        this.codeArea.getCaretSelectionBind().paragraphIndexProperty().addListener(listener);
    }

    public void addColumnIndexListener(ChangeListener<Integer> listener) {
        this.codeArea.caretColumnProperty().addListener(listener);
    }

    public void addFocusListener(ChangeListener<Boolean> listener) {
        this.codeArea.focusedProperty().addListener(listener);
    }

    public static enum LineNumbersPolicy {
        SHOW,
        DO_NOT_SHOW;

    }

    public static enum HighlighterPolicy {
        HIGHLIGHT,
        DO_NOT_HIGHLIGHT;

    }

    public static enum WrappingPolicy {
        WRAP_LINES,
        NO_WRAP;

    }
}

