/*
 * Decompiled with CFR 0.152.
 */
package com.sqlines.studio.view.mainwindow.editor;

import com.sqlines.studio.resource.HighlighterKeywords;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyleSpansBuilder;

public class Highlighter {
    private static Pattern pattern;
    private final HighlighterKeywords keywords;

    public Highlighter(HighlighterKeywords keywords) {
        this.keywords = keywords;
        if (pattern == null) {
            this.compilePattern();
        }
    }

    private void compilePattern() {
        String keywordRegex = "\\b(" + String.join((CharSequence)"|", this.keywords.getKeywords()) + ")\\b";
        String digitRegex = "\\b[0-9]+\\b";
        String stringRegex = "\"([^\"\\\\]|\\\\.)*\"";
        String charRegex = "'.*'";
        String commentRegex = "//[^\n]*|/\\*(.|\\R)*?\\*/|/\\*[^\\v]*|^\\h*\\*([^\\v]*|/)|--[^\n]*";
        pattern = Pattern.compile("(?<KEYWORD>" + keywordRegex + ")|(?<DIGIT>" + digitRegex + ")|(?<STRING>" + stringRegex + ")|(?<CHAR>" + charRegex + ")|(?<COMMENT>" + commentRegex + ")", 2);
    }

    public StyleSpans<Collection<String>> computeHighlighting(String text) {
        StyleSpansBuilder<Collection<Object>> spansBuilder = new StyleSpansBuilder<Collection<Object>>();
        int lastKnownEnd = 0;
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            String styleClass = this.getStyleClass(matcher);
            spansBuilder.add(Collections.emptyList(), matcher.start() - lastKnownEnd);
            spansBuilder.add(Collections.singleton(styleClass), matcher.end() - matcher.start());
            lastKnownEnd = matcher.end();
        }
        spansBuilder.add(Collections.emptyList(), text.length() - lastKnownEnd);
        return spansBuilder.create();
    }

    private String getStyleClass(Matcher matcher) {
        return matcher.group("KEYWORD") != null ? "keyword" : (matcher.group("DIGIT") != null ? "digit" : (matcher.group("STRING") != null ? "string" : (matcher.group("CHAR") != null ? "char" : "comment")));
    }
}

