/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.beans.NamedArg;
import org.fxmisc.richtext.CaretSelectionBind;
import org.fxmisc.richtext.NavigationActions;
import org.fxmisc.richtext.StyleClassedTextArea;
import org.fxmisc.richtext.model.EditableStyledDocument;

public class CodeArea
extends StyleClassedTextArea {
    protected Pattern WORD_PATTERN;
    protected Pattern WORD_OR_SYMBOL;

    public CodeArea(@NamedArg(value="document") EditableStyledDocument<Collection<String>, String, Collection<String>> document) {
        super(document, false);
        this.getStyleClass().add("code-area");
        this.getStylesheets().add(CodeArea.class.getResource("code-area.css").toExternalForm());
        this.setUseInitialStyleForInsertion(true);
        this.WORD_PATTERN = Pattern.compile("\\w+");
        this.WORD_OR_SYMBOL = Pattern.compile("([\\W&&[^\\h]]{2}|\\w*)\\h*");
    }

    public CodeArea() {
        super(false);
        this.getStyleClass().add("code-area");
        this.getStylesheets().add(CodeArea.class.getResource("code-area.css").toExternalForm());
        this.setUseInitialStyleForInsertion(true);
        this.WORD_PATTERN = Pattern.compile("\\w+");
        this.WORD_OR_SYMBOL = Pattern.compile("([\\W&&[^\\h]]{2}|\\w*)\\h*");
    }

    public CodeArea(@NamedArg(value="text") String text) {
        this();
        this.appendText(text);
        this.getUndoManager().forgetHistory();
        this.getUndoManager().mark();
        this.selectRange(0, 0);
    }

    @Override
    public void wordBreaksBackwards(int n, NavigationActions.SelectionPolicy selectionPolicy) {
        if (this.getLength() == 0) {
            return;
        }
        CaretSelectionBind csb = this.getCaretSelectionBind();
        int paragraph = csb.getParagraphIndex();
        int position = csb.getColumnPosition();
        int prevWord = 0;
        if (position == 0) {
            prevWord = this.getParagraph(--paragraph).length();
            this.moveTo(paragraph, prevWord, selectionPolicy);
            return;
        }
        Matcher m = this.WORD_OR_SYMBOL.matcher(this.getText(paragraph));
        while (m.find()) {
            if (m.start() == position) {
                this.moveTo(paragraph, prevWord, selectionPolicy);
                break;
            }
            prevWord = m.end();
            if (prevWord < position) continue;
            this.moveTo(paragraph, m.start(), selectionPolicy);
            break;
        }
    }

    @Override
    public void wordBreaksForwards(int n, NavigationActions.SelectionPolicy selectionPolicy) {
        if (this.getLength() == 0) {
            return;
        }
        CaretSelectionBind csb = this.getCaretSelectionBind();
        int paragraph = csb.getParagraphIndex();
        int position = csb.getColumnPosition();
        Matcher m = this.WORD_OR_SYMBOL.matcher(this.getText(paragraph));
        while (m.find()) {
            if (m.start() > position) {
                this.moveTo(paragraph, m.start(), selectionPolicy);
                break;
            }
            if (!m.hitEnd()) continue;
            this.moveTo(paragraph + 1, 0, selectionPolicy);
        }
    }

    @Override
    public void selectWord() {
        if (this.getLength() == 0) {
            return;
        }
        CaretSelectionBind csb = this.getCaretSelectionBind();
        int paragraph = csb.getParagraphIndex();
        int position = csb.getColumnPosition();
        Matcher m = this.WORD_PATTERN.matcher(this.getText(paragraph));
        while (m.find()) {
            if (m.end() <= position) continue;
            csb.selectRange(paragraph, m.start(), paragraph, m.end());
            return;
        }
    }
}

