/*
 * Decompiled with CFR 0.152.
 */
package com.sqlines.studio.boot;

import com.sqlines.studio.model.filemanager.FileManager;
import com.sqlines.studio.model.license.License;
import com.sqlines.studio.model.tabs.ObservableTabs;
import com.sqlines.studio.model.tabs.Tab;
import com.sqlines.studio.properties.PropertiesManager;
import com.sqlines.studio.util.Serialization;
import com.sqlines.studio.view.mainwindow.MainWindow;
import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.stage.Stage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ConfigurableApplicationContext;

@SpringBootApplication
public class SQLinesStudioSpringApplication
extends Application {
    private static final Logger log = LogManager.getLogger(SQLinesStudioSpringApplication.class);
    private ConfigurableApplicationContext context;
    private final ExecutorService threadPull = Executors.newFixedThreadPool(3);
    private ObservableTabs tabs;
    private FileManager fileManager;
    private License license;
    private MainWindow mainWindow;
    private final AtomicBoolean checkpointActive = new AtomicBoolean(true);
    private final AtomicBoolean fileMonitoringActive = new AtomicBoolean(true);
    private final AtomicBoolean licenseMonitoringActive = new AtomicBoolean(true);

    public static void main(String[] args) {
        SQLinesStudioSpringApplication.launch(args);
    }

    @Override
    public void init() {
        this.loadProperties();
        this.createInitialDir();
    }

    private void loadProperties() {
        try {
            PropertiesManager.loadProperties();
            log.info("Properties loaded");
        }
        catch (Exception exc) {
            log.error("Properties loading failed: " + exc.getMessage());
            PropertiesManager.setDefaults();
        }
    }

    private void createInitialDir() {
        try {
            String path = PropertiesManager.get("CURR_DIR");
            File file = new File(path);
            if (!file.exists()) {
                if (file.mkdir()) {
                    log.info("Created initial directory: " + path);
                } else {
                    log.error("Cannot create directory: " + path);
                }
            }
        }
        catch (Exception exc) {
            log.error("Cannot create initial directory: " + exc.getMessage());
        }
    }

    @Override
    public void start(Stage stage) {
        this.buildContext();
        this.threadPull.execute(this::runCheckpointLoop);
        this.threadPull.execute(this::runFileMonitoringLoop);
        this.threadPull.execute(this::runLicenseMonitoringLoop);
    }

    private void buildContext() {
        SpringApplicationBuilder builder = new SpringApplicationBuilder(SQLinesStudioSpringApplication.class);
        builder.application().setWebApplicationType(WebApplicationType.NONE);
        this.context = builder.run(this.getParameters().getRaw().toArray(new String[0]));
        this.tabs = this.context.getBean(ObservableTabs.class);
        this.fileManager = this.context.getBean(FileManager.class);
        this.license = this.context.getBean(License.class);
        this.mainWindow = this.context.getBean(MainWindow.class);
    }

    private void runCheckpointLoop() {
        log.info("Running checkpoint loop");
        while (this.checkpointActive.get()) {
            try {
                Thread.sleep(40000L);
                Serialization.serializeTabs(this.tabs);
                Serialization.serializeFileManager(this.fileManager);
                log.info("Checkpoint made. Application state saved");
            }
            catch (InterruptedException exc) {
                log.info("Stopping checkpoint loop");
                Thread.currentThread().interrupt();
                break;
            }
            catch (Exception exc) {
                log.error("Checkpoint error: " + exc.getMessage());
            }
        }
    }

    private void runFileMonitoringLoop() {
        log.info("Running file monitoring");
        while (this.fileMonitoringActive.get()) {
            try {
                this.fileManager.check();
                Thread.sleep(2000L);
            }
            catch (InterruptedException exc) {
                log.info("Stopping file monitoring");
                Thread.currentThread().interrupt();
                break;
            }
            catch (Exception exc) {
                log.error("File monitoring error: " + exc);
            }
        }
    }

    private void runLicenseMonitoringLoop() {
        log.info("Running license monitoring");
        while (this.licenseMonitoringActive.get()) {
            try {
                Thread.sleep(10000L);
                this.license.check();
            }
            catch (InterruptedException exc) {
                log.info("Stopping license monitoring");
                Thread.currentThread().interrupt();
                break;
            }
            catch (Exception exc) {
                log.error("License check error: " + exc.getMessage());
            }
        }
    }

    @Override
    public void stop() {
        try {
            this.checkpointActive.set(false);
            this.fileMonitoringActive.set(false);
            this.licenseMonitoringActive.set(false);
            this.threadPull.shutdownNow();
            this.saveFiles();
            this.saveProperties();
            this.saveLastState();
            this.context.close();
            Platform.exit();
        }
        catch (Exception exc) {
            log.error(exc.getMessage());
        }
    }

    private void saveFiles() {
        for (Tab tab : this.tabs) {
            String sourcePath = tab.getSourceFilePath();
            String targetPath = tab.getTargetFilePath();
            if (!sourcePath.isEmpty()) {
                this.fileManager.saveFile(sourcePath, tab.getSourceText());
            }
            if (targetPath.isEmpty()) continue;
            this.fileManager.saveFile(targetPath, tab.getTargetText());
        }
    }

    private void saveProperties() {
        try {
            this.saveUISettings();
            PropertiesManager.saveProperties();
            log.info("UI properties saved");
        }
        catch (Exception e) {
            log.warn("UI properties saving failed: " + e.getMessage());
        }
    }

    private void saveUISettings() {
        PropertiesManager.set("WINDOW_HEIGHT", String.valueOf(this.mainWindow.getHeight()));
        PropertiesManager.set("WINDOW_WIDTH", String.valueOf(this.mainWindow.getWidth()));
        PropertiesManager.set("WINDOW_X", String.valueOf(this.mainWindow.getX()));
        PropertiesManager.set("WINDOW_Y", String.valueOf(this.mainWindow.getY()));
        PropertiesManager.set("WINDOW_MAXIMIZED", String.valueOf(this.mainWindow.isMaximized()));
    }

    private void saveLastState() {
        try {
            Serialization.serializeTabs(this.tabs);
            Serialization.serializeFileManager(this.fileManager);
            log.info("Last state saved");
        }
        catch (Exception exc) {
            log.error("Saving last session error: " + exc.getMessage());
        }
    }
}

