/*
 * Decompiled with CFR 0.152.
 */
package com.sqlines.studio.model.converter;

import com.sqlines.studio.model.converter.ConversionResult;
import com.sqlines.studio.model.converter.Converter;
import com.sqlines.studio.model.converter.ConverterParameters;
import com.sqlines.studio.model.converter.exception.ConverterRuntimeException;
import com.sqlines.studio.model.converter.exception.ConverterStartException;
import com.sqlines.studio.model.sqlines.SqlinesCmdArguments;
import com.sqlines.studio.model.sqlines.SqlinesRunner;
import com.sqlines.studio.model.sqlines.ecxeption.SqlinesNotFoundException;
import com.sqlines.studio.resource.ConversionModes;
import com.sqlines.studio.util.file.FileCreator;
import com.sqlines.studio.util.file.FileDeleter;
import com.sqlines.studio.util.file.FileReader;
import com.sqlines.studio.util.file.FileStatsProvider;
import com.sqlines.studio.util.file.FileWriter;
import java.io.IOException;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConverterImpl
implements Converter {
    private static final Logger log = LogManager.getLogger(ConverterImpl.class);
    private final ConversionModes conversionModes;
    private final SqlinesRunner sqlines;
    private final Supplier<String> currentDirSupplier;
    private final FileReader fileReader;
    private final FileWriter fileWriter;
    private final FileCreator fileCreator;
    private final FileDeleter fileDeleter;
    private final FileStatsProvider fileStatsProvider;

    @Override
    public ConversionResult run(ConverterParameters parameters) {
        log.info("Running conversion with parameters: " + parameters);
        if (parameters.getSourceFilePath() != null) {
            return this.run(parameters.getSourceMode(), parameters.getTargetMode(), parameters.getSourceFilePath(), parameters.getTargetFileName());
        }
        return this.runWithoutSource(parameters.getSourceMode(), parameters.getTargetMode(), parameters.getSourceData(), parameters.getTargetFileName());
    }

    private ConversionResult run(String sourceMode, String targetMode, String sourceFilePath, String targetFileName) {
        String logFilePath = "";
        try {
            logFilePath = this.createLogFile();
            String targetPath = this.getTargetFile(targetFileName, targetMode);
            SqlinesCmdArguments arguments = SqlinesCmdArguments.builder().sourceMode(this.getCmdMode(sourceMode)).targetMode(this.getCmdMode(targetMode)).sourceFilePath(sourceFilePath).targetFilePath(targetPath).logFilePath(logFilePath).build();
            this.sqlines.runAndWait(arguments);
            ConversionResult conversionResult = this.getResult(targetPath);
            return conversionResult;
        }
        catch (SqlinesNotFoundException exc) {
            throw new ConverterStartException(exc.getMessage(), exc);
        }
        catch (Exception exc) {
            throw new ConverterRuntimeException(exc.getMessage(), exc);
        }
        finally {
            this.deleteFile(logFilePath);
        }
    }

    private ConversionResult runWithoutSource(String sourceMode, String targetMode, String sourceData, String targetFileName) {
        String sourceFilePath = "";
        try {
            sourceFilePath = this.createTempSourceFile(sourceData);
            ConversionResult conversionResult = this.run(sourceMode, targetMode, sourceFilePath, targetFileName);
            return conversionResult;
        }
        catch (IOException exc) {
            throw new ConverterStartException(exc.getMessage(), exc);
        }
        finally {
            this.deleteFile(sourceFilePath);
        }
    }

    private String createLogFile() {
        String path = "";
        try {
            path = this.fileCreator.createTmpFile("sqlines-log");
            log.info("Created temporary log file: " + path);
        }
        catch (IOException exc) {
            log.error("Cannot create log file: " + exc.getMessage());
        }
        return path;
    }

    private String getCmdMode(String rowMode) {
        String cmdMode = this.conversionModes.getCmdModes().get(rowMode);
        if (cmdMode == null) {
            String errorMsg = "No config file in application resources: source-modes.txt or target-modes.txt";
            throw new ConverterRuntimeException(errorMsg);
        }
        return cmdMode;
    }

    private String getTargetFile(String fileName, String targetMode) throws IOException {
        String path = "";
        try {
            path = this.buildTargetFilePath(fileName, targetMode);
            if (!this.fileStatsProvider.exists(path)) {
                this.fileCreator.createFile(path);
                log.info("Created target file: " + path);
            }
            return path;
        }
        catch (IOException exc) {
            String errorMsg = "Cannot create target file: " + path;
            throw new IOException(errorMsg, exc);
        }
    }

    private String buildTargetFilePath(String fileName, String targetMode) {
        return this.currentDirSupplier.get() + "/" + fileName.replaceAll("\\s+", "") + "_" + targetMode + ".sql";
    }

    private ConversionResult getResult(String filePath) throws IOException {
        try {
            String result = this.fileReader.read(filePath);
            log.info("Read target file:" + filePath);
            return new ConversionResult(result, filePath);
        }
        catch (IOException exc) {
            String errorMsg = "Cannot read target file: " + filePath;
            throw new IOException(errorMsg, exc);
        }
    }

    private void deleteFile(String filePath) {
        try {
            this.fileDeleter.delete(filePath);
            log.info("File deleted: " + filePath);
        }
        catch (Exception exc) {
            log.error("Cannot delete " + filePath);
        }
    }

    private String createTempSourceFile(String data) throws IOException {
        try {
            String path = this.fileCreator.createTmpFile("sqlined-temp");
            this.fileWriter.write(path, data);
            log.info("Created temporary source file: " + path);
            return path;
        }
        catch (IOException exc) {
            throw new IOException("Cannot create temporary source file", exc);
        }
    }

    public ConverterImpl(ConversionModes conversionModes, SqlinesRunner sqlines, Supplier<String> currentDirSupplier, FileReader fileReader, FileWriter fileWriter, FileCreator fileCreator, FileDeleter fileDeleter, FileStatsProvider fileStatsProvider) {
        this.conversionModes = conversionModes;
        this.sqlines = sqlines;
        this.currentDirSupplier = currentDirSupplier;
        this.fileReader = fileReader;
        this.fileWriter = fileWriter;
        this.fileCreator = fileCreator;
        this.fileDeleter = fileDeleter;
        this.fileStatsProvider = fileStatsProvider;
    }
}

