/*
 * Decompiled with CFR 0.152.
 */
package com.sqlines.studio.properties;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PropertiesManager {
    private static final Logger log = LogManager.getLogger(PropertiesManager.class);
    public static final String CURR_DIR = "CURR_DIR";
    public static final String DIRS_NUMBER = "DIRS_NUMBER";
    public static final String APP_DIR = "APP_DIR";
    public static final String LAST_DIR = "LAST_DIR";
    public static final String DIR = "DIR";
    public static final String APPEARANCE = "APPEARANCE";
    public static final String SHOW_STATUS_BAR = "SHOW_STATUS_BAR";
    public static final String SHOW_TARGET_FIELD = "SHOW_TARGET_FIELD";
    public static final String WRAP_LINES = "WRAP_LINES";
    public static final String HIGHLIGHTER = "HIGHLIGHTER";
    public static final String SHOW_LINE_NUMBERS = "SHOW_LINE_NUMBERS";
    public static final String WINDOW_HEIGHT = "WINDOW_HEIGHT";
    public static final String WINDOW_WIDTH = "WINDOW_WIDTH";
    public static final String WINDOW_X = "WINDOW_X";
    public static final String WINDOW_Y = "WINDOW_Y";
    public static final String WINDOW_MAXIMIZED = "WINDOW_MAXIMIZED";
    private static final Properties properties = System.getProperties();
    private static final String PROPERTIES_FILE = properties.getProperty("java.io.tmpdir") + "sqlines-properties.txt";

    private PropertiesManager() {
    }

    public static void setDefaults() {
        PropertiesManager.serDefaultModelProperties();
        PropertiesManager.serDefaultViewProperties();
        PropertiesManager.loadAppDir();
    }

    private static void serDefaultModelProperties() {
        int dirsNumber = Integer.parseInt(properties.getProperty(DIRS_NUMBER, "0"));
        for (int i = 0; i < dirsNumber; ++i) {
            properties.remove(DIR + i);
        }
        String currDir = properties.getProperty("user.home") + "/sqlines";
        properties.setProperty(CURR_DIR, currDir);
        properties.setProperty(DIRS_NUMBER, "0");
        properties.setProperty(LAST_DIR, "null");
    }

    private static void loadAppDir() {
        try {
            String appPath = PropertiesManager.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            appPath = appPath.substring(0, appPath.lastIndexOf("/"));
            properties.setProperty(APP_DIR, appPath);
        }
        catch (Exception e) {
            log.error("Loading application dir: " + e.getMessage());
        }
    }

    private static void serDefaultViewProperties() {
        PropertiesManager.set(APPEARANCE, APPEARANCE_VALUES.LIGHT);
        PropertiesManager.set(SHOW_STATUS_BAR, STATUS_BAR_VALUES.SHOW);
        PropertiesManager.set(SHOW_TARGET_FIELD, TARGET_FIELD_VALUES.ALWAYS);
        PropertiesManager.set(WRAP_LINES, WRAP_LINES_VALUES.WRAP);
        PropertiesManager.set(HIGHLIGHTER, HIGHLIGHTER_VALUES.ENABLED);
        PropertiesManager.set(SHOW_LINE_NUMBERS, LINE_NUMBERS_VALUES.SHOW);
        PropertiesManager.set(WINDOW_HEIGHT, "650.0");
        PropertiesManager.set(WINDOW_WIDTH, "770.0");
        PropertiesManager.set(WINDOW_X, "0.0");
        PropertiesManager.set(WINDOW_Y, "0.0");
        PropertiesManager.set(WINDOW_MAXIMIZED, MAXIMIZED_VALUES.MINIMIZED);
    }

    public static void loadProperties() throws IOException {
        try (FileInputStream stream = new FileInputStream(PROPERTIES_FILE);){
            properties.load(stream);
            PropertiesManager.loadAppDir();
        }
    }

    public static void saveProperties() throws IOException {
        File file = new File(PROPERTIES_FILE);
        if (!file.exists()) {
            file = PropertiesManager.createFile(PROPERTIES_FILE);
        }
        PropertiesManager.saveToFile(file);
    }

    private static File createFile(String path) throws IOException {
        File file = new File(path);
        boolean success = file.createNewFile();
        if (!success) {
            throw new IOException("Cannot create properties file: " + path);
        }
        return file;
    }

    private static void saveToFile(File file) throws IOException {
        try (FileOutputStream stream = new FileOutputStream(file);){
            properties.store(stream, "SQLines Studio properties");
        }
    }

    public static String get(String key) {
        return System.getProperty(key);
    }

    public static String get(String key, String defaultValue) {
        return System.getProperty(key, defaultValue);
    }

    public static <C extends Enum<C>> String get(String key, Enum<C> defaultValue) {
        return PropertiesManager.get(key, defaultValue.toString());
    }

    public static void set(String key, String value) {
        System.setProperty(key, value);
    }

    public static <C extends Enum<C>> void set(String key, Enum<C> value) {
        PropertiesManager.set(key, value.toString());
    }

    static {
        PropertiesManager.setDefaults();
    }

    public static enum MAXIMIZED_VALUES {
        MAXIMIZED,
        MINIMIZED;

    }

    public static enum LINE_NUMBERS_VALUES {
        SHOW,
        DO_NOT_SHOW;

    }

    public static enum HIGHLIGHTER_VALUES {
        ENABLED,
        DISABLED;

    }

    public static enum WRAP_LINES_VALUES {
        WRAP,
        DO_NOT_WRAP;

    }

    public static enum TARGET_FIELD_VALUES {
        ALWAYS,
        AS_NEEDED;

    }

    public static enum STATUS_BAR_VALUES {
        SHOW,
        DO_NOT_SHOW;

    }

    public static enum APPEARANCE_VALUES {
        LIGHT,
        DARK;

    }
}

