/*
 * Decompiled with CFR 0.152.
 */
package com.sqlines.studio.util;

import com.sqlines.studio.model.filemanager.FileManager;
import com.sqlines.studio.model.filemanager.FileManagerImpl;
import com.sqlines.studio.model.tabs.LinkedListTabs;
import com.sqlines.studio.model.tabs.ObservableTabs;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Serialization {
    private Serialization() {
    }

    public static void serializeTabs(ObservableTabs tabs) throws IOException {
        try (ObjectOutputStream stream = Serialization.getOutStream("sqlines-tabs.serial");){
            stream.writeObject(tabs);
        }
    }

    private static ObjectOutputStream getOutStream(String name) throws IOException {
        String path = System.getProperty("java.io.tmpdir") + name;
        return new ObjectOutputStream(new FileOutputStream(path));
    }

    public static void serializeFileManager(FileManager manager) throws IOException {
        try (ObjectOutputStream stream = Serialization.getOutStream("sqlines-files.serial");){
            stream.writeObject(manager);
        }
    }

    public static LinkedListTabs deserializeTabs() throws IOException, ClassNotFoundException {
        try (ObjectInputStream stream = Serialization.getDataInStream("sqlines-tabs.serial");){
            LinkedListTabs linkedListTabs = (LinkedListTabs)stream.readObject();
            return linkedListTabs;
        }
    }

    private static ObjectInputStream getDataInStream(String name) throws IOException {
        String path = System.getProperty("java.io.tmpdir") + name;
        return new ObjectInputStream(new FileInputStream(path));
    }

    public static FileManagerImpl deserializeFileManager() throws IOException, ClassNotFoundException {
        try (ObjectInputStream stream = Serialization.getDataInStream("sqlines-files.serial");){
            FileManagerImpl fileManagerImpl = (FileManagerImpl)stream.readObject();
            return fileManagerImpl;
        }
    }
}

