/*
 * Decompiled with CFR 0.152.
 */
package com.sqlines.studio.view.mainwindow;

import com.sqlines.studio.view.mainwindow.editor.CodeEditor;
import java.util.Optional;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.HBox;

public class CentralNode
extends HBox {
    private final CodeEditor sourceEditor;
    private final CodeEditor targetEditor;

    public CentralNode(CodeEditor sourceEditor, CodeEditor targetEditor) {
        this.sourceEditor = sourceEditor;
        this.targetEditor = targetEditor;
        this.setUp();
        this.showTargetFieldOnTextChange();
    }

    private void setUp() {
        this.getChildren().addAll((Node[])new Node[]{this.sourceEditor});
        this.setSpacing(10.0);
        this.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
    }

    private void showTargetFieldOnTextChange() {
        this.targetEditor.addTextListener((observable, oldText, newText) -> {
            if (!newText.isEmpty() && !this.getChildren().contains(this.targetEditor)) {
                this.getChildren().add(this.targetEditor);
            }
        });
    }

    public void setSourceText(String text) {
        this.sourceEditor.setText(text);
    }

    public void setTargetText(String text) {
        this.targetEditor.setText(text);
    }

    public int getSourceLineIndex() {
        return this.sourceEditor.getLineIndex();
    }

    public int getTargetLineIndex() {
        return this.targetEditor.getLineIndex();
    }

    public int getSourceColumnIndex() {
        return this.sourceEditor.getColumnIndex();
    }

    public int getTargetColumnIndex() {
        return this.targetEditor.getColumnIndex();
    }

    public void undo() {
        Optional<CodeEditor> inFocus2 = this.inFocus();
        inFocus2.ifPresent(CodeEditor::undo);
    }

    private Optional<CodeEditor> inFocus() {
        if (this.sourceEditor.hasFocus()) {
            return Optional.of(this.sourceEditor);
        }
        if (this.targetEditor.hasFocus()) {
            return Optional.of(this.targetEditor);
        }
        return Optional.empty();
    }

    public void redo() {
        Optional<CodeEditor> inFocus2 = this.inFocus();
        inFocus2.ifPresent(CodeEditor::redo);
    }

    public void selectAll() {
        Optional<CodeEditor> inFocus2 = this.inFocus();
        inFocus2.ifPresent(CodeEditor::selectAll);
    }

    public void cut() {
        Optional<CodeEditor> inFocus2 = this.inFocus();
        inFocus2.ifPresent(CodeEditor::cut);
    }

    public void copy() {
        Optional<CodeEditor> inFocus2 = this.inFocus();
        inFocus2.ifPresent(CodeEditor::copy);
    }

    public void paste() {
        Optional<CodeEditor> inFocus2 = this.inFocus();
        inFocus2.ifPresent(CodeEditor::paste);
    }

    public boolean isUndoAvailable() {
        Optional<CodeEditor> inFocus2 = this.inFocus();
        return inFocus2.map(CodeEditor::isUndoAvailable).orElse(false);
    }

    public boolean isRedoAvailable() {
        Optional<CodeEditor> inFocus2 = this.inFocus();
        return inFocus2.map(CodeEditor::isRedoAvailable).orElse(false);
    }

    public void zoomIn() {
        this.sourceEditor.zoomIn();
        this.targetEditor.zoomIn();
    }

    public void zoomOut() {
        this.sourceEditor.zoomOut();
        this.targetEditor.zoomOut();
    }

    public void focusOn(inFocus inFocus2) {
        if (inFocus2 == inFocus.SOURCE) {
            this.sourceEditor.requestFocus();
        } else if (inFocus2 == inFocus.TARGET) {
            this.targetEditor.requestFocus();
        }
    }

    public void setTargetFieldPolicy(TargetFieldPolicy policy) {
        if (policy == TargetFieldPolicy.ALWAYS && !this.getChildren().contains(this.targetEditor)) {
            this.getChildren().add(this.targetEditor);
        } else if (policy == TargetFieldPolicy.AS_NEEDED && this.targetEditor.getText().isEmpty()) {
            this.getChildren().remove(this.targetEditor);
        }
    }

    public void setWrappingPolicy(CodeEditor.WrappingPolicy policy) {
        this.sourceEditor.setWrappingPolicy(policy);
        this.targetEditor.setWrappingPolicy(policy);
    }

    public void setHighlighterPolicy(CodeEditor.HighlighterPolicy policy) {
        this.sourceEditor.setHighlighterPolicy(policy);
        this.targetEditor.setHighlighterPolicy(policy);
    }

    public void setLineNumbersPolicy(CodeEditor.LineNumbersPolicy policy) {
        this.sourceEditor.setLineNumbersPolicy(policy);
        this.targetEditor.setLineNumbersPolicy(policy);
    }

    public void addSourceTextListener(ChangeListener<String> listener) {
        this.sourceEditor.addTextListener(listener);
    }

    public void addTargetTextListener(ChangeListener<String> listener) {
        this.targetEditor.addTextListener(listener);
    }

    public void addSourceLineIndexListener(ChangeListener<Integer> listener) {
        this.sourceEditor.addLineIndexListener(listener);
    }

    public void addTargetLineIndexListener(ChangeListener<Integer> listener) {
        this.targetEditor.addLineIndexListener(listener);
    }

    public void addSourceColumnIndexListener(ChangeListener<Integer> listener) {
        this.sourceEditor.addColumnIndexListener(listener);
    }

    public void addTargetColumnIndexListener(ChangeListener<Integer> listener) {
        this.targetEditor.addColumnIndexListener(listener);
    }

    public void addSourceFocusListener(ChangeListener<Boolean> listener) {
        this.sourceEditor.addFocusListener(listener);
    }

    public void addTargetFocusListener(ChangeListener<Boolean> listener) {
        this.targetEditor.addFocusListener(listener);
    }

    public static enum TargetFieldPolicy {
        ALWAYS,
        AS_NEEDED;

    }

    public static enum inFocus {
        SOURCE,
        TARGET;

    }
}

