/*
 * Decompiled with CFR 0.152.
 */
package com.sqlines.studio.view.mainwindow;

import com.sqlines.studio.resource.UIResource;
import java.util.Collection;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Separator;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.text.Text;

public class MainToolBar
extends ToolBar {
    private final Button newTabButton = new Button();
    private final Button openFileButton = new Button();
    private final Button saveFileButton = new Button();
    private final Button runButton = new Button();
    private final ChoiceBox<String> sourceModesBox = new ChoiceBox();
    private final ChoiceBox<String> targetModesBox = new ChoiceBox();

    public MainToolBar(UIResource openTabIcon, UIResource openFileIcon, UIResource saveFileIcon, UIResource runIcon) {
        this.ignoreKeyEvents();
        this.setUpNewTabButton(openTabIcon.getUrl());
        this.setUpOpenFileButton(openFileIcon.getUrl());
        this.setUpSaveFileButton(saveFileIcon.getUrl());
        this.setUpRunButton(runIcon.getUrl());
        this.setUpModeBoxes();
        this.setUpLayout();
    }

    private void ignoreKeyEvents() {
        this.addEventFilter(KeyEvent.ANY, keyEvent -> {
            if (keyEvent.getCode() == KeyCode.TAB || keyEvent.getCode() == KeyCode.RIGHT || keyEvent.getCode() == KeyCode.LEFT || keyEvent.getCode() == KeyCode.UP || keyEvent.getCode() == KeyCode.DOWN) {
                keyEvent.consume();
            }
        });
    }

    private void setUpNewTabButton(String icon) {
        ImageView newTabImg = new ImageView(new Image(icon));
        newTabImg.setFitHeight(17.0);
        newTabImg.setFitWidth(17.0);
        this.newTabButton.setGraphic(newTabImg);
        this.newTabButton.setTooltip(new Tooltip("New tab"));
    }

    private void setUpOpenFileButton(String icon) {
        ImageView openFileImg = new ImageView(new Image(icon));
        openFileImg.setFitHeight(17.0);
        openFileImg.setFitWidth(17.0);
        this.openFileButton.setGraphic(openFileImg);
        this.openFileButton.setTooltip(new Tooltip("Open file"));
    }

    private void setUpSaveFileButton(String icon) {
        ImageView saveFileImg = new ImageView(new Image(icon));
        saveFileImg.setFitHeight(17.0);
        saveFileImg.setFitWidth(17.0);
        this.saveFileButton.setGraphic(saveFileImg);
        this.saveFileButton.setTooltip(new Tooltip("Save file"));
    }

    private void setUpRunButton(String icon) {
        ImageView runImg = new ImageView(new Image(icon));
        runImg.setFitHeight(17.0);
        runImg.setFitWidth(17.0);
        this.runButton.setGraphic(runImg);
        this.runButton.setTooltip(new Tooltip("Run conversion"));
    }

    private void setUpModeBoxes() {
        this.sourceModesBox.setTooltip(new Tooltip("Source conversion mode"));
        this.targetModesBox.setTooltip(new Tooltip("Target conversion mode"));
    }

    private void setUpLayout() {
        this.getItems().add(this.newTabButton);
        this.getItems().add(new Separator());
        this.getItems().addAll((Node[])new Node[]{this.openFileButton, this.saveFileButton});
        this.getItems().add(new Separator());
        this.getItems().add(this.runButton);
        this.getItems().add(new Separator());
        this.getItems().addAll((Node[])new Node[]{new Text(" Source:  "), this.sourceModesBox, new Text(" Target:  "), this.targetModesBox});
    }

    public String getSourceMode() {
        String currMode = (String)this.sourceModesBox.getSelectionModel().getSelectedItem();
        if (currMode == null) {
            throw new IllegalStateException("No source mode selected");
        }
        return currMode;
    }

    public String getTargetMode() {
        String currMode = (String)this.targetModesBox.getSelectionModel().getSelectedItem();
        if (currMode == null) {
            throw new IllegalStateException("No target mode selected");
        }
        return currMode;
    }

    public void setSourceModes(List<String> modes) {
        if (modes.isEmpty()) {
            throw new IllegalArgumentException("List of source modes is empty");
        }
        this.sourceModesBox.getItems().addAll((Collection<String>)modes);
        this.sourceModesBox.setValue((String)this.sourceModesBox.getItems().get(0));
    }

    public void setTargetModes(List<String> modes) {
        if (modes.isEmpty()) {
            throw new IllegalArgumentException("List of target modes is empty");
        }
        this.targetModesBox.getItems().addAll((Collection<String>)modes);
        this.targetModesBox.setValue((String)this.targetModesBox.getItems().get(0));
    }

    public void selectSourceMode(String mode) {
        if (!this.sourceModesBox.getItems().contains(mode)) {
            throw new IllegalArgumentException("Such a mode does not exist: " + mode);
        }
        this.sourceModesBox.getSelectionModel().select(mode);
    }

    public void selectTargetMode(String mode) {
        if (!this.targetModesBox.getItems().contains(mode)) {
            throw new IllegalArgumentException("Such a mode does not exist: " + mode);
        }
        this.targetModesBox.getSelectionModel().select(mode);
    }

    public void addSourceModeListener(ChangeListener<String> listener) {
        this.sourceModesBox.getSelectionModel().selectedItemProperty().addListener(listener);
    }

    public void addTargetModeListener(ChangeListener<String> listener) {
        this.targetModesBox.getSelectionModel().selectedItemProperty().addListener(listener);
    }

    public void addFocusListener(ChangeListener<Boolean> listener) {
        this.newTabButton.focusedProperty().addListener(listener);
        this.openFileButton.focusedProperty().addListener(listener);
        this.saveFileButton.focusedProperty().addListener(listener);
        this.runButton.focusedProperty().addListener(listener);
        this.sourceModesBox.focusedProperty().addListener(listener);
        this.targetModesBox.focusedProperty().addListener(listener);
    }

    public void setOnNewTabAction(EventHandler<ActionEvent> action) {
        this.newTabButton.setOnAction(action);
    }

    public void setOnOpenFileAction(EventHandler<ActionEvent> action) {
        this.openFileButton.setOnAction(action);
    }

    public void setOnSaveFileAction(EventHandler<ActionEvent> action) {
        this.saveFileButton.setOnAction(action);
    }

    public void setOnRunAction(EventHandler<ActionEvent> action) {
        this.runButton.setOnAction(action);
    }
}

