/*
 * Decompiled with CFR 0.152.
 */
package com.sqlines.studio.view.mainwindow;

import com.sqlines.studio.view.AbstractWindow;
import com.sqlines.studio.view.BaseView;
import com.sqlines.studio.view.ErrorWindow;
import com.sqlines.studio.view.mainwindow.AboutWindow;
import com.sqlines.studio.view.mainwindow.CentralNode;
import com.sqlines.studio.view.mainwindow.MainMenuBar;
import com.sqlines.studio.view.mainwindow.MainStatusBar;
import com.sqlines.studio.view.mainwindow.MainToolBar;
import com.sqlines.studio.view.mainwindow.MainWindowSettingsView;
import com.sqlines.studio.view.mainwindow.MainWindowView;
import com.sqlines.studio.view.mainwindow.editor.CodeEditor;
import com.sqlines.studio.view.mainwindow.event.RecentFileEvent;
import com.sqlines.studio.view.mainwindow.event.TabCloseEvent;
import com.sqlines.studio.view.mainwindow.listener.FocusChangeListener;
import com.sqlines.studio.view.mainwindow.listener.ModeChangeListener;
import com.sqlines.studio.view.mainwindow.listener.TabTitleChangeListener;
import com.sqlines.studio.view.mainwindow.listener.TextChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.input.DragEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.WindowEvent;

public class MainWindow
extends AbstractWindow
implements MainWindowView,
MainWindowSettingsView {
    private final MainToolBar toolBar;
    private final MainMenuBar menuBar;
    private final MainStatusBar statusBar;
    private final Supplier<CentralNode> centralNodeSupplier;
    private final Supplier<ErrorWindow> errorWindowSupplier;
    private final Supplier<AboutWindow> aboutWindowSupplier;
    private final BorderPane layout = new BorderPane();
    private final TabPane tabBar = new TabPane();
    private final List<TabTitleChangeListener> tabTitleListeners = new ArrayList<TabTitleChangeListener>(5);
    private final List<ModeChangeListener> sourceModeListeners = new ArrayList<ModeChangeListener>(5);
    private final List<ModeChangeListener> targetModeListeners = new ArrayList<ModeChangeListener>(5);
    private final List<TextChangeListener> sourceTextListeners = new ArrayList<TextChangeListener>(5);
    private final List<TextChangeListener> targetTextListeners = new ArrayList<TextChangeListener>(5);
    private final List<FocusChangeListener> focusListeners = new ArrayList<FocusChangeListener>(5);
    private EventHandler<TabCloseEvent> tabCloseEventHandler;
    private EventHandler<DragEvent> dragEventHandler;
    private EventHandler<DragEvent> dropEventHandler;
    private MainWindowView.FieldInFocus inFocus = MainWindowView.FieldInFocus.SOURCE;
    private MainWindowSettingsView.TargetFieldPolicy targetFieldPolicy = MainWindowSettingsView.TargetFieldPolicy.AS_NEEDED;
    private MainWindowSettingsView.WrappingPolicy wrappingPolicy = MainWindowSettingsView.WrappingPolicy.NO_WRAP;
    private MainWindowSettingsView.HighlighterPolicy highlighterPolicy = MainWindowSettingsView.HighlighterPolicy.HIGHLIGHT;
    private MainWindowSettingsView.LineNumbersPolicy lineNumbersPolicy = MainWindowSettingsView.LineNumbersPolicy.SHOW;

    public MainWindow(MainToolBar toolBar, MainMenuBar menuBar, MainStatusBar statusBar, Supplier<ErrorWindow> errorWindowSupplier, Supplier<AboutWindow> aboutWindowSupplier, Supplier<CentralNode> centralNodeFactory) {
        this.toolBar = toolBar;
        this.menuBar = menuBar;
        this.statusBar = statusBar;
        this.errorWindowSupplier = errorWindowSupplier;
        this.aboutWindowSupplier = aboutWindowSupplier;
        this.centralNodeSupplier = centralNodeFactory;
        this.setUpMenuBar();
        this.setUpTabBar();
        this.setUpScene();
        this.setUpWindow();
        this.setUpMenuBarEventHandlers();
        this.setUpTabBarEventHandlers();
        this.setUpToolBarEventHandlers();
        this.ignoreTabBarKeyEvents();
    }

    private void setUpMenuBar() {
        this.menuBar.setCloseTabState(false);
        this.menuBar.setNextTabState(false);
        this.menuBar.setPrevTabState(false);
        this.menuBar.setOpenRecentState(false);
        this.menuBar.setUndoState(false);
        this.menuBar.setRedoState(false);
        this.menuBar.setStatusBarSelected(true);
        this.menuBar.setTargetFieldSelected(false);
        this.menuBar.setWrappingSelected(false);
        this.menuBar.setHighlighterSelected(true);
        this.menuBar.setLineNumbersSelected(true);
    }

    private void setUpTabBar() {
        this.tabBar.setTabClosingPolicy(TabPane.TabClosingPolicy.ALL_TABS);
    }

    private void setUpScene() {
        this.layout.setTop(new VBox(this.menuBar, this.toolBar));
        this.layout.setCenter(this.tabBar);
        this.layout.setBottom(this.statusBar);
        this.setRoot(this.layout);
    }

    private void setUpWindow() {
        this.setTitle("SQLines Studio");
        this.setMinWidth(660.0);
        this.setMinHeight(300.0);
        this.setWidth(770.0);
        this.setHeight(650.0);
    }

    private void setUpMenuBarEventHandlers() {
        this.menuBar.setOnCloseTabAction(this::handleTabCloseEvent);
        this.menuBar.setOnAboutAction(event -> this.showAbout());
        this.menuBar.setOnNextTabAction(event -> this.nextTab());
        this.menuBar.setOnPrevTabAction(event -> this.prevTab());
        this.menuBar.setOnUndoAction(event -> this.undo());
        this.menuBar.setOnRedoAction(event -> this.redo());
        this.menuBar.setOnSelectAllAction(event -> this.selectAll());
        this.menuBar.setOnCutAction(event -> this.cut());
        this.menuBar.setOnCopyAction(event -> this.copy());
        this.menuBar.setOnPasteAction(event -> this.paste());
        this.menuBar.setOnZoomInAction(event -> this.zoomIn());
        this.menuBar.setOnZoomOutAction(event -> this.zoomOut());
    }

    private void handleTabCloseEvent(ActionEvent event) {
        int tabIndex = this.tabBar.getSelectionModel().getSelectedIndex();
        TabCloseEvent closeEvent = new TabCloseEvent(tabIndex);
        this.tabBar.fireEvent(closeEvent);
        if (this.tabCloseEventHandler != null) {
            this.tabCloseEventHandler.handle(closeEvent);
            event.consume();
        }
    }

    private void showAbout() {
        AboutWindow window = this.aboutWindowSupplier.get();
        this.setStylesheets(window);
        window.show();
    }

    private void setStylesheets(AbstractWindow window) {
        BaseView.Appearance appearance = this.getAppearance();
        if (appearance == BaseView.Appearance.LIGHT) {
            window.setLightStylesheets(this.getLightStylesheets());
        } else if (appearance == BaseView.Appearance.DARK) {
            window.setDarkStylesheets(this.getDarkStylesheets());
        }
        window.setAppearance(appearance);
    }

    private void nextTab() {
        int currIndex = this.tabBar.getSelectionModel().getSelectedIndex();
        if (currIndex != this.tabBar.getTabs().size() - 1) {
            this.tabBar.getSelectionModel().select(currIndex + 1);
        }
    }

    private void prevTab() {
        int currIndex = this.tabBar.getSelectionModel().getSelectedIndex();
        if (currIndex != 0) {
            this.tabBar.getSelectionModel().select(currIndex - 1);
        }
    }

    private void undo() {
        CentralNode centralNode = this.getSelectedCentralNode();
        centralNode.undo();
    }

    private CentralNode getSelectedCentralNode() {
        Tab currTab = (Tab)this.tabBar.getSelectionModel().getSelectedItem();
        return (CentralNode)currTab.getContent();
    }

    private void redo() {
        CentralNode centralNode = this.getSelectedCentralNode();
        centralNode.redo();
    }

    private void selectAll() {
        CentralNode centralNode = this.getSelectedCentralNode();
        centralNode.selectAll();
    }

    private void cut() {
        CentralNode centralNode = this.getSelectedCentralNode();
        centralNode.cut();
    }

    private void copy() {
        CentralNode centralNode = this.getSelectedCentralNode();
        centralNode.copy();
    }

    private void paste() {
        CentralNode centralNode = this.getSelectedCentralNode();
        centralNode.paste();
    }

    private void zoomIn() {
        for (Tab tab : this.tabBar.getTabs()) {
            CentralNode centralNode = (CentralNode)tab.getContent();
            centralNode.zoomIn();
        }
    }

    private void zoomOut() {
        for (Tab tab : this.tabBar.getTabs()) {
            CentralNode centralNode = (CentralNode)tab.getContent();
            centralNode.zoomOut();
        }
    }

    private void setUpTabBarEventHandlers() {
        this.tabBar.setOnDragOver(this::handleDragEvent);
        this.tabBar.setOnDragDropped(this::handleDropEvent);
        this.tabBar.focusedProperty().addListener((o, old, n) -> this.focusChanged());
        this.tabBar.getSelectionModel().selectedIndexProperty().addListener((o, oldInd, newInd) -> this.tabSelectionChanged((Number)oldInd, (Number)newInd));
    }

    private void handleDragEvent(DragEvent event) {
        if (this.dragEventHandler != null) {
            this.dragEventHandler.handle(event);
        }
    }

    private void handleDropEvent(DragEvent event) {
        if (this.dropEventHandler != null) {
            this.dropEventHandler.handle(event);
        }
    }

    private void focusChanged() {
        if (this.tabBar.getSelectionModel().getSelectedIndex() == -1) {
            return;
        }
        CentralNode centralNode = this.getSelectedCentralNode();
        this.restoreFocus(centralNode);
        this.setShortcutsAvailable(centralNode);
    }

    private void setShortcutsAvailable(CentralNode centralNode) {
        this.menuBar.setUndoState(centralNode.isUndoAvailable());
        this.menuBar.setRedoState(centralNode.isRedoAvailable());
    }

    private void restoreFocus(CentralNode centralNode) {
        if (this.inFocus == MainWindowView.FieldInFocus.SOURCE) {
            centralNode.focusOn(CentralNode.inFocus.SOURCE);
        } else if (this.inFocus == MainWindowView.FieldInFocus.TARGET) {
            centralNode.focusOn(CentralNode.inFocus.TARGET);
        }
    }

    private void tabSelectionChanged(Number oldIndex, Number newIndex) {
        if (oldIndex.intValue() == -1) {
            return;
        }
        int tabIndex = newIndex.intValue();
        this.menuBar.setPrevTabState(tabIndex > 0);
        this.menuBar.setNextTabState(tabIndex != this.tabBar.getTabs().size() - 1);
        CentralNode centralNode = this.getSelectedCentralNode();
        centralNode.focusOn(CentralNode.inFocus.SOURCE);
    }

    private void setUpToolBarEventHandlers() {
        this.toolBar.addSourceModeListener((ObservableValue<String> o, String old, String newMode) -> this.sourceModeChanged((String)newMode));
        this.toolBar.addTargetModeListener((ObservableValue<String> o, String old, String newMode) -> this.targetModeChanged((String)newMode));
        this.toolBar.addFocusListener((ObservableValue<Boolean> o, Boolean old, Boolean n) -> this.focusChanged());
    }

    private void sourceModeChanged(String newMode) {
        int currIndex = this.tabBar.getSelectionModel().getSelectedIndex();
        this.sourceModeListeners.forEach(listener -> listener.changed(newMode, currIndex));
    }

    private void targetModeChanged(String newMode) {
        int currIndex = this.tabBar.getSelectionModel().getSelectedIndex();
        this.targetModeListeners.forEach(listener -> listener.changed(newMode, currIndex));
    }

    private void ignoreTabBarKeyEvents() {
        this.tabBar.addEventFilter(KeyEvent.ANY, keyEvent -> {
            if ((keyEvent.getCode() == KeyCode.TAB || keyEvent.getCode() == KeyCode.RIGHT || keyEvent.getCode() == KeyCode.LEFT || keyEvent.getCode() == KeyCode.UP || keyEvent.getCode() == KeyCode.DOWN) && this.tabBar.isFocused()) {
                keyEvent.consume();
            }
        });
    }

    public void setConversionModes(List<String> sourceModes, List<String> targetModes) {
        this.toolBar.setSourceModes(sourceModes);
        this.toolBar.setTargetModes(targetModes);
    }

    @Override
    public MainWindowView.FieldInFocus inFocus(int tabIndex) {
        this.checkRange(tabIndex, 0, this.tabBar.getTabs().size());
        return this.inFocus;
    }

    private void checkRange(int tabIndex, int from, int to) {
        if (tabIndex < from || tabIndex >= to) {
            int endInd = this.tabBar.getTabs().isEmpty() ? 0 : this.tabBar.getTabs().size() - 1;
            String errorMsg = "Invalid index: (0:" + endInd + ") expected, " + tabIndex + " provided";
            throw new IndexOutOfBoundsException(errorMsg);
        }
    }

    @Override
    public String getSourceMode() {
        return this.toolBar.getSourceMode();
    }

    @Override
    public String getTargetMode() {
        return this.toolBar.getTargetMode();
    }

    @Override
    public String getTabTitle(int tabIndex) {
        Tab tab = (Tab)this.tabBar.getTabs().get(tabIndex);
        return tab.getText();
    }

    @Override
    public void setSourceMode(String mode) {
        this.toolBar.selectSourceMode(mode);
    }

    @Override
    public void setTargetMode(String mode) {
        this.toolBar.selectTargetMode(mode);
    }

    @Override
    public void setSourceText(String text, int tabIndex) {
        this.checkRange(tabIndex, 0, this.tabBar.getTabs().size());
        Tab tab = (Tab)this.tabBar.getTabs().get(tabIndex);
        CentralNode centralNode = (CentralNode)tab.getContent();
        centralNode.setSourceText(text);
    }

    @Override
    public void setTargetText(String text, int tabIndex) {
        this.checkRange(tabIndex, 0, this.tabBar.getTabs().size());
        Tab tab = (Tab)this.tabBar.getTabs().get(tabIndex);
        CentralNode centralNode = (CentralNode)tab.getContent();
        centralNode.setTargetText(text);
    }

    @Override
    public void setWindowTitle(String title) {
        this.setTitle(title);
    }

    @Override
    public void setTabTitle(String title, int tabIndex) {
        this.checkRange(tabIndex, 0, this.tabBar.getTabs().size());
        Tab tab = (Tab)this.tabBar.getTabs().get(tabIndex);
        tab.setText(title);
        this.tabTitleListeners.forEach(listener -> listener.changed(title, tabIndex));
    }

    @Override
    public void setCurrTabIndex(int tabIndex) {
        this.checkRange(tabIndex, 0, this.tabBar.getTabs().size());
        this.tabBar.getSelectionModel().select(tabIndex);
    }

    @Override
    public void setStatusBarPolicy(MainWindowSettingsView.StatusBarPolicy policy) {
        if (policy == MainWindowSettingsView.StatusBarPolicy.SHOW) {
            this.addStatusBar();
        } else if (policy == MainWindowSettingsView.StatusBarPolicy.DO_NOT_SHOW) {
            this.removeStatusBar();
        }
    }

    private void addStatusBar() {
        if (this.layout.getChildren().contains(this.statusBar)) {
            return;
        }
        this.layout.setBottom(this.statusBar);
        this.menuBar.setStatusBarSelected(true);
    }

    private void removeStatusBar() {
        this.layout.getChildren().remove(this.statusBar);
        this.menuBar.setStatusBarSelected(false);
    }

    @Override
    public void setTargetFieldPolicy(MainWindowSettingsView.TargetFieldPolicy policy) {
        this.targetFieldPolicy = policy;
        if (policy == MainWindowSettingsView.TargetFieldPolicy.ALWAYS) {
            this.showTargetFieldInEveryTab();
        } else if (policy == MainWindowSettingsView.TargetFieldPolicy.AS_NEEDED) {
            this.hideTargetFieldInEveryTab();
        }
    }

    private void showTargetFieldInEveryTab() {
        this.tabBar.getTabs().forEach(tab -> {
            CentralNode centralNode = (CentralNode)tab.getContent();
            centralNode.setTargetFieldPolicy(CentralNode.TargetFieldPolicy.ALWAYS);
        });
        this.menuBar.setTargetFieldSelected(true);
    }

    private void hideTargetFieldInEveryTab() {
        this.tabBar.getTabs().forEach(tab -> {
            CentralNode centralNode = (CentralNode)tab.getContent();
            centralNode.setTargetFieldPolicy(CentralNode.TargetFieldPolicy.AS_NEEDED);
        });
        this.menuBar.setTargetFieldSelected(false);
    }

    @Override
    public void setWrappingPolicy(MainWindowSettingsView.WrappingPolicy policy) {
        this.wrappingPolicy = policy;
        if (policy == MainWindowSettingsView.WrappingPolicy.WRAP_LINES) {
            this.wrapLinesInEveryTab();
        } else if (policy == MainWindowSettingsView.WrappingPolicy.NO_WRAP) {
            this.doNotWrapLinesInEveryTab();
        }
    }

    private void wrapLinesInEveryTab() {
        this.tabBar.getTabs().forEach(tab -> {
            CentralNode centralNode = (CentralNode)tab.getContent();
            centralNode.setWrappingPolicy(CodeEditor.WrappingPolicy.WRAP_LINES);
        });
        this.menuBar.setWrappingSelected(true);
    }

    private void doNotWrapLinesInEveryTab() {
        this.tabBar.getTabs().forEach(tab -> {
            CentralNode centralNode = (CentralNode)tab.getContent();
            centralNode.setWrappingPolicy(CodeEditor.WrappingPolicy.NO_WRAP);
        });
        this.menuBar.setWrappingSelected(false);
    }

    @Override
    public void setHighlighterPolicy(MainWindowSettingsView.HighlighterPolicy policy) {
        this.highlighterPolicy = policy;
        if (policy == MainWindowSettingsView.HighlighterPolicy.HIGHLIGHT) {
            this.highlightInEveryTab();
        } else if (policy == MainWindowSettingsView.HighlighterPolicy.DO_NOT_HIGHLIGHT) {
            this.doNotHighlightInEveryTab();
        }
    }

    private void highlightInEveryTab() {
        this.tabBar.getTabs().forEach(tab -> {
            CentralNode centralNode = (CentralNode)tab.getContent();
            centralNode.setHighlighterPolicy(CodeEditor.HighlighterPolicy.HIGHLIGHT);
        });
        this.menuBar.setHighlighterSelected(true);
    }

    private void doNotHighlightInEveryTab() {
        this.tabBar.getTabs().forEach(tab -> {
            CentralNode centralNode = (CentralNode)tab.getContent();
            centralNode.setHighlighterPolicy(CodeEditor.HighlighterPolicy.DO_NOT_HIGHLIGHT);
        });
        this.menuBar.setHighlighterSelected(false);
    }

    @Override
    public void setLineNumbersPolicy(MainWindowSettingsView.LineNumbersPolicy policy) {
        this.lineNumbersPolicy = policy;
        if (policy == MainWindowSettingsView.LineNumbersPolicy.SHOW) {
            this.showLineNumbersInEveryTab();
        } else if (policy == MainWindowSettingsView.LineNumbersPolicy.DO_NOT_SHOW) {
            this.hideLineNumbersInEveryTab();
        }
    }

    private void showLineNumbersInEveryTab() {
        this.tabBar.getTabs().forEach(tab -> {
            CentralNode centralNode = (CentralNode)tab.getContent();
            centralNode.setLineNumbersPolicy(CodeEditor.LineNumbersPolicy.SHOW);
        });
        this.statusBar.showLineColumnNumberArea(true);
        this.menuBar.setLineNumbersSelected(true);
    }

    private void hideLineNumbersInEveryTab() {
        this.tabBar.getTabs().forEach(tab -> {
            CentralNode centralNode = (CentralNode)tab.getContent();
            centralNode.setLineNumbersPolicy(CodeEditor.LineNumbersPolicy.DO_NOT_SHOW);
        });
        this.statusBar.showLineColumnNumberArea(false);
        this.menuBar.setLineNumbersSelected(false);
    }

    @Override
    public void openTab(int tabIndex) {
        this.checkRange(tabIndex, 0, this.tabBar.getTabs().size() + 1);
        this.createNewTab(tabIndex);
        this.notifyModeListeners(tabIndex);
        this.setClosablePolicyInEveryTab();
    }

    private void createNewTab(int tabIndex) {
        Tab newTab = new Tab();
        this.createCentralNode(newTab);
        this.setTabTitle(newTab, tabIndex);
        newTab.setOnCloseRequest((Event event) -> this.handleTabCloseEvent(newTab, event));
        this.tabBar.getTabs().add(tabIndex, newTab);
        this.tabBar.getSelectionModel().select(tabIndex);
    }

    private void setTabTitle(Tab tab, int tabIndex) {
        List<Integer> tabNumbers = this.getTabNumbers();
        String title = this.getNextTabTile(tabNumbers);
        tab.setText(title);
        this.tabTitleListeners.forEach(listener -> listener.changed(title, tabIndex));
    }

    private List<Integer> getTabNumbers() {
        LinkedList<Integer> tabNumbers = new LinkedList<Integer>();
        this.tabBar.getTabs().forEach(item -> {
            StringBuilder tabTitle = new StringBuilder(item.getText());
            tabTitle.delete(0, 4);
            try {
                int tabNumber = Integer.parseInt(tabTitle.toString());
                tabNumbers.add(tabNumber);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        return tabNumbers;
    }

    private String getNextTabTile(List<Integer> tabNumbers) {
        int i;
        Collections.sort(tabNumbers);
        for (i = 0; i < tabNumbers.size() && tabNumbers.get(i) == i + 1; ++i) {
        }
        return "Tab " + (i + 1);
    }

    private void createCentralNode(Tab tab) {
        CentralNode centralNode = this.centralNodeSupplier.get();
        this.setUpCentralNode(tab, centralNode);
        tab.setContent(centralNode);
    }

    private void setUpCentralNode(Tab tab, CentralNode centralNode) {
        this.setTargetFieldPolicy(centralNode);
        this.setWrappingPolicy(centralNode);
        this.setHighlightingPolicy(centralNode);
        this.setLineNumbersPolicy(centralNode);
        this.setUpEventListeners(centralNode, tab);
    }

    private void setTargetFieldPolicy(CentralNode centralNode) {
        if (this.targetFieldPolicy == MainWindowSettingsView.TargetFieldPolicy.ALWAYS) {
            centralNode.setTargetFieldPolicy(CentralNode.TargetFieldPolicy.ALWAYS);
        } else if (this.targetFieldPolicy == MainWindowSettingsView.TargetFieldPolicy.AS_NEEDED) {
            centralNode.setTargetFieldPolicy(CentralNode.TargetFieldPolicy.AS_NEEDED);
        }
    }

    private void setWrappingPolicy(CentralNode centralNode) {
        if (this.wrappingPolicy == MainWindowSettingsView.WrappingPolicy.WRAP_LINES) {
            centralNode.setWrappingPolicy(CodeEditor.WrappingPolicy.WRAP_LINES);
        } else if (this.wrappingPolicy == MainWindowSettingsView.WrappingPolicy.NO_WRAP) {
            centralNode.setWrappingPolicy(CodeEditor.WrappingPolicy.NO_WRAP);
        }
    }

    private void setHighlightingPolicy(CentralNode centralNode) {
        if (this.highlighterPolicy == MainWindowSettingsView.HighlighterPolicy.HIGHLIGHT) {
            centralNode.setHighlighterPolicy(CodeEditor.HighlighterPolicy.HIGHLIGHT);
        } else if (this.highlighterPolicy == MainWindowSettingsView.HighlighterPolicy.DO_NOT_HIGHLIGHT) {
            centralNode.setHighlighterPolicy(CodeEditor.HighlighterPolicy.DO_NOT_HIGHLIGHT);
        }
    }

    private void setLineNumbersPolicy(CentralNode centralNode) {
        if (this.lineNumbersPolicy == MainWindowSettingsView.LineNumbersPolicy.SHOW) {
            centralNode.setLineNumbersPolicy(CodeEditor.LineNumbersPolicy.SHOW);
        } else if (this.lineNumbersPolicy == MainWindowSettingsView.LineNumbersPolicy.DO_NOT_SHOW) {
            centralNode.setLineNumbersPolicy(CodeEditor.LineNumbersPolicy.DO_NOT_SHOW);
        }
    }

    private void setUpEventListeners(CentralNode centralNode, Tab tab) {
        centralNode.addSourceTextListener((ObservableValue<String> o, String oldText, String newText) -> this.handleSourceTextChangeEvent(centralNode, tab, (String)newText));
        centralNode.addTargetTextListener((ObservableValue<String> o, String oldText, String newText) -> this.handleTargetTextChangeEvent(centralNode, tab, (String)newText));
        centralNode.addSourceLineIndexListener((o, oldNum, newNum) -> this.lineNumberChanged((int)newNum));
        centralNode.addSourceColumnIndexListener((o, oldNum, newNum) -> this.columnNumberChanged((int)newNum));
        centralNode.addTargetLineIndexListener((o, oldNum, newNum) -> this.lineNumberChanged((int)newNum));
        centralNode.addTargetColumnIndexListener((o, oldNum, newNum) -> this.columnNumberChanged((int)newNum));
        centralNode.addSourceFocusListener((o, wasFocused, isFocused) -> {
            if (isFocused.booleanValue()) {
                this.focusInTabChanged(centralNode, MainWindowView.FieldInFocus.SOURCE);
            }
        });
        centralNode.addTargetFocusListener((o, wasFocused, isFocused) -> {
            if (isFocused.booleanValue()) {
                this.focusInTabChanged(centralNode, MainWindowView.FieldInFocus.TARGET);
            }
        });
    }

    private void handleSourceTextChangeEvent(CentralNode centralNode, Tab tab, String newText) {
        this.setShortcutsAvailable(centralNode);
        int tabIndex = this.tabBar.getTabs().indexOf(tab);
        this.sourceTextListeners.forEach(listener -> listener.changed(newText, tabIndex));
    }

    private void handleTargetTextChangeEvent(CentralNode centralNode, Tab tab, String newText) {
        this.setShortcutsAvailable(centralNode);
        int tabIndex = this.tabBar.getTabs().indexOf(tab);
        this.targetTextListeners.forEach(listener -> listener.changed(newText, tabIndex));
    }

    private void lineNumberChanged(int newNumber) {
        int lineNumber = newNumber + 1;
        this.statusBar.setLineNumber(lineNumber);
    }

    private void columnNumberChanged(int newNumber) {
        int columnNumber = newNumber + 1;
        this.statusBar.setColumnNumber(columnNumber);
    }

    private void focusInTabChanged(CentralNode centralNode, MainWindowView.FieldInFocus fieldInFocus) {
        this.inFocus = fieldInFocus;
        this.statusBar.setLineNumber(this.getLineIndexInFocusedField() + 1);
        this.statusBar.setColumnNumber(this.getColumnIndexInFocusedField() + 1);
        this.setShortcutsAvailable(centralNode);
        this.notifyFocusListeners(this.inFocus, this.tabBar.getSelectionModel().getSelectedIndex());
    }

    private int getLineIndexInFocusedField() {
        CentralNode centralNode = this.getSelectedCentralNode();
        if (this.inFocus == MainWindowView.FieldInFocus.SOURCE) {
            return centralNode.getSourceLineIndex();
        }
        return centralNode.getTargetLineIndex();
    }

    private int getColumnIndexInFocusedField() {
        CentralNode centralNode = this.getSelectedCentralNode();
        if (this.inFocus == MainWindowView.FieldInFocus.SOURCE) {
            return centralNode.getSourceColumnIndex();
        }
        return centralNode.getTargetColumnIndex();
    }

    private void notifyFocusListeners(MainWindowView.FieldInFocus inFocus2, int tabIndex) {
        this.focusListeners.forEach(listener -> listener.changed(inFocus2, tabIndex));
    }

    private void handleTabCloseEvent(Tab tab, Event event) {
        int index = this.tabBar.getTabs().indexOf(tab);
        TabCloseEvent closeEvent = new TabCloseEvent(index);
        this.tabBar.fireEvent(closeEvent);
        if (this.tabCloseEventHandler != null) {
            this.tabCloseEventHandler.handle(closeEvent);
            event.consume();
        }
    }

    private void setClosablePolicyInEveryTab() {
        int tabsNumber = this.tabBar.getTabs().size();
        this.menuBar.setCloseTabState(tabsNumber != 1);
        this.tabBar.getTabs().forEach(tab -> tab.setClosable(tabsNumber != 1));
    }

    private void notifyModeListeners(int tabIndex) {
        this.sourceModeListeners.forEach(listener -> listener.changed(this.toolBar.getSourceMode(), tabIndex));
        this.targetModeListeners.forEach(listener -> listener.changed(this.toolBar.getTargetMode(), tabIndex));
    }

    @Override
    public void closeTab(int tabIndex) {
        this.checkRange(tabIndex, 0, this.tabBar.getTabs().size());
        this.tabBar.getTabs().remove(tabIndex);
        this.setClosablePolicyInEveryTab();
        if (tabIndex != 0) {
            CentralNode centralNode = this.getSelectedCentralNode();
            centralNode.focusOn(CentralNode.inFocus.SOURCE);
        }
    }

    @Override
    public void closeAllTabs() {
        this.tabBar.getTabs().clear();
    }

    @Override
    public void showConversionStart(int tabIndex) {
        this.checkRange(tabIndex, 0, this.tabBar.getTabs().size());
        CentralNode centralNode = this.getSelectedCentralNode();
        centralNode.setDisable(true);
    }

    @Override
    public void showConversionEnd(int tabIndex) {
        this.checkRange(tabIndex, 0, this.tabBar.getTabs().size());
        CentralNode centralNode = this.getSelectedCentralNode();
        centralNode.setDisable(false);
        centralNode.focusOn(CentralNode.inFocus.TARGET);
    }

    @Override
    public void showError(String cause, String errorMsg) {
        ErrorWindow window = this.errorWindowSupplier.get();
        this.setStylesheets(window);
        window.setError(cause, errorMsg);
        window.show();
    }

    @Override
    public void showFilePath(String filePath) {
        this.statusBar.setFilePath(filePath);
    }

    @Override
    public Optional<List<File>> choseFilesToOpen() {
        FileChooser chooser = new FileChooser();
        List<File> files = chooser.showOpenMultipleDialog(this);
        return Optional.ofNullable(files);
    }

    @Override
    public Optional<List<File>> choseFilesToOpen(File initialDir) {
        FileChooser chooser = new FileChooser();
        chooser.setInitialDirectory(initialDir);
        List<File> files = chooser.showOpenMultipleDialog(this);
        return Optional.ofNullable(files);
    }

    @Override
    public Optional<String> choseFileSavingLocation() {
        FileChooser chooser = new FileChooser();
        File dir = chooser.showSaveDialog(this);
        return Optional.ofNullable(dir).map(File::getAbsolutePath);
    }

    @Override
    public void addRecentFile(String filePath) {
        this.menuBar.addRecentFile(filePath);
        this.menuBar.setOpenRecentState(true);
    }

    @Override
    public void clearRecentFiles() {
        this.menuBar.clearRecentFiles();
        this.menuBar.setOpenRecentState(false);
    }

    @Override
    public void moveRecentFile(String filePath, int moveTo) {
        this.menuBar.moveRecentFile(filePath, moveTo);
    }

    @Override
    public void addTabSelectionListener(ChangeListener<Number> listener) {
        this.tabBar.getSelectionModel().selectedIndexProperty().addListener(listener);
    }

    @Override
    public void removeTabSelectionListener(ChangeListener<Number> listener) {
        this.tabBar.getSelectionModel().selectedIndexProperty().removeListener(listener);
    }

    @Override
    public void addTabTitleListener(TabTitleChangeListener listener) {
        this.tabTitleListeners.add(listener);
    }

    @Override
    public void removeTabTitleListener(TabTitleChangeListener listener) {
        this.tabTitleListeners.remove(listener);
    }

    @Override
    public void addSourceTextListener(TextChangeListener listener) {
        this.sourceTextListeners.add(listener);
    }

    @Override
    public void removeSourceTextListener(TextChangeListener listener) {
        this.sourceTextListeners.remove(listener);
    }

    @Override
    public void addTargetTextListener(TextChangeListener listener) {
        this.targetTextListeners.add(listener);
    }

    @Override
    public void removeTargetTextListener(TextChangeListener listener) {
        this.targetTextListeners.remove(listener);
    }

    @Override
    public void addSourceModeListener(ModeChangeListener listener) {
        this.sourceModeListeners.add(listener);
    }

    @Override
    public void removeSourceModeListener(ModeChangeListener listener) {
        this.sourceModeListeners.remove(listener);
    }

    @Override
    public void addTargetModeListener(ModeChangeListener listener) {
        this.targetModeListeners.add(listener);
    }

    @Override
    public void removeTargetModeListener(ModeChangeListener listener) {
        this.targetModeListeners.remove(listener);
    }

    @Override
    public void addFocusListener(FocusChangeListener listener) {
        this.focusListeners.add(listener);
    }

    @Override
    public void setOnCloseAction(EventHandler<WindowEvent> action) {
        this.setOnCloseRequest(action);
    }

    @Override
    public void setOnDragAction(EventHandler<DragEvent> action) {
        this.dragEventHandler = action;
    }

    @Override
    public void setOnDropAction(EventHandler<DragEvent> action) {
        this.dropEventHandler = action;
    }

    @Override
    public void setOnPreferencesAction(EventHandler<ActionEvent> action) {
        this.menuBar.setOnPreferencesAction(action);
    }

    @Override
    public void setOnNewTabAction(EventHandler<ActionEvent> action) {
        this.menuBar.setOnNewTabAction(action);
        this.toolBar.setOnNewTabAction(action);
    }

    @Override
    public void setOnCloseTabAction(EventHandler<TabCloseEvent> action) {
        this.tabCloseEventHandler = action;
    }

    @Override
    public void setOnOpenFileAction(EventHandler<ActionEvent> action) {
        this.menuBar.setOnOpenFileAction(action);
        this.toolBar.setOnOpenFileAction(action);
    }

    @Override
    public void setOnRecentFileAction(EventHandler<RecentFileEvent> action) {
        this.menuBar.setOnOpenRecentAction(action);
    }

    @Override
    public void setOnClearRecentAction(EventHandler<ActionEvent> action) {
        this.menuBar.setOnClearRecentAction(action);
    }

    @Override
    public void setOnSaveFileAction(EventHandler<ActionEvent> action) {
        this.menuBar.setOnSaveFileAction(action);
        this.toolBar.setOnSaveFileAction(action);
    }

    @Override
    public void setOnSaveAsAction(EventHandler<ActionEvent> action) {
        this.menuBar.setOnSaveAsAction(action);
    }

    @Override
    public void setOnRunAction(EventHandler<ActionEvent> action) {
        this.menuBar.setOnRunAction(action);
        this.toolBar.setOnRunAction(action);
    }

    @Override
    public void setOnOnlineHelpAction(EventHandler<ActionEvent> action) {
        this.menuBar.setOnOnlineHelpAction(action);
    }

    @Override
    public void setOnOpenSiteAction(EventHandler<ActionEvent> action) {
        this.menuBar.setOnOpenSiteAction(action);
    }

    @Override
    public void setOnStatusBarAction(EventHandler<ActionEvent> action) {
        this.menuBar.setOnStatusBarAction(action);
    }

    @Override
    public void setOnTargetFieldAction(EventHandler<ActionEvent> action) {
        this.menuBar.setOnTargetFieldAction(action);
    }

    @Override
    public void setOnWrappingAction(EventHandler<ActionEvent> action) {
        this.menuBar.setOnWrappingAction(action);
    }

    @Override
    public void setOnHighlighterAction(EventHandler<ActionEvent> action) {
        this.menuBar.setOnHighlighterAction(action);
    }

    @Override
    public void setOnLineNumbersAction(EventHandler<ActionEvent> action) {
        this.menuBar.setOnLineNumbersAction(action);
    }
}

