/*
 * Decompiled with CFR 0.152.
 */
package de.jangassen.jfa;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.ByteByReference;
import com.sun.jna.ptr.PointerByReference;
import de.jangassen.jfa.FoundationMethod;
import de.jangassen.jfa.FoundationProxyHandler;
import de.jangassen.jfa.annotation.Superclass;
import de.jangassen.jfa.appkit.NSInvocation;
import de.jangassen.jfa.appkit.NSMethodSignature;
import de.jangassen.jfa.appkit.NSObject;
import de.jangassen.jfa.foundation.Foundation;
import de.jangassen.jfa.foundation.ID;

@Superclass(value="NSProxy")
public class FoundationProxy {
    private final NSObject target;
    private final FoundationProxyHandler handler;
    private final Pointer respondsToSelector;

    public FoundationProxy(NSObject target, FoundationProxyHandler handler) {
        this.target = target;
        this.handler = handler;
        this.respondsToSelector = Foundation.createSelector("respondsToSelector:");
    }

    public void forwardInvocation(NSInvocation invocation) {
        if (this.handler.hasAdditionalMethods()) {
            Pointer selector = new Pointer(invocation.selector().longValue());
            if (this.respondsToSelector.equals(selector)) {
                PointerByReference ref = new PointerByReference();
                invocation.getArgument(ref, 2);
                if (this.handler.hasAdditionalMethod(ref.getValue())) {
                    ByteByReference result = new ByteByReference(1);
                    invocation.setReturnValue(result);
                    return;
                }
            } else {
                FoundationMethod additionalMethod = this.handler.getAdditionalMethod(selector);
                if (additionalMethod != null) {
                    additionalMethod.invoke(invocation);
                    return;
                }
            }
        }
        if (this.handler.beforeTarget(invocation)) {
            invocation.invokeWithTarget(this.target);
            this.handler.afterTarget(invocation);
        }
    }

    public NSMethodSignature methodSignatureForSelector(ID sel) {
        FoundationMethod additionalMethod;
        if (this.handler.hasAdditionalMethods() && (additionalMethod = this.handler.getAdditionalMethod(new Pointer(sel.longValue()))) != null) {
            return additionalMethod.getMethodSignature();
        }
        return this.target.methodSignatureForSelector(sel);
    }
}

