/*
 * Decompiled with CFR 0.152.
 */
package de.jangassen.platform.mac.convert;

import de.jangassen.jfa.FoundationCallback;
import de.jangassen.jfa.FoundationCallbackRegistry;
import de.jangassen.jfa.ObjcToJava;
import de.jangassen.jfa.appkit.NSMenuItem;
import de.jangassen.jfa.cleanup.NSCleaner;
import de.jangassen.platform.mac.convert.ImageConverter;
import java.util.Optional;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;

public class MenuItemConverter {
    private static final String SEPARATOR_ITEM = "separatorItem";
    public static final FoundationCallback VOID_CALLBACK = new FoundationCallback(null, null);

    private MenuItemConverter() {
    }

    public static NSMenuItem convert(MenuItem menuItem) {
        if (menuItem == null) {
            return null;
        }
        if (menuItem instanceof SeparatorMenuItem) {
            return ObjcToJava.invokeStatic(NSMenuItem.class, SEPARATOR_ITEM, new Object[0]);
        }
        return MenuItemConverter.convertMenuItem(menuItem);
    }

    private static NSMenuItem convertMenuItem(MenuItem menuItem) {
        FoundationCallback foundationCallback = MenuItemConverter.getFoundationCallback(menuItem.getOnAction());
        NSMenuItem nsMenuItem = MenuItemConverter.createNsMenuItem(menuItem, foundationCallback);
        menuItem.textProperty().addListener((observable, oldValue, newValue) -> nsMenuItem.setTitle((String)newValue));
        menuItem.onActionProperty().addListener((observable, oldValue, newValue) -> MenuItemConverter.updateAction(menuItem, nsMenuItem, newValue));
        menuItem.acceleratorProperty().addListener((observable, oldValue, newValue) -> nsMenuItem.setKeyEquivalent(MenuItemConverter.toKeyEquivalentString(newValue)));
        nsMenuItem.setKeyEquivalentModifierMask(MenuItemConverter.toKeyEventModifierFlags(menuItem.getAccelerator()));
        menuItem.acceleratorProperty().addListener((observable, oldValue, newValue) -> nsMenuItem.setKeyEquivalentModifierMask(MenuItemConverter.toKeyEventModifierFlags(newValue)));
        ImageConverter.convert(menuItem.getGraphic()).ifPresent(nsMenuItem::setImage);
        menuItem.graphicProperty().addListener((observable, oldValue, newValue) -> ImageConverter.convert(newValue).ifPresent(nsMenuItem::setImage));
        NSCleaner.register((Object)menuItem, nsMenuItem);
        MenuItemConverter.registerCallbackForCleanup(menuItem, foundationCallback);
        return nsMenuItem;
    }

    private static void updateAction(MenuItem menuItem, NSMenuItem nsMenuItem, EventHandler<ActionEvent> eventHandler) {
        FoundationCallback foundationCallback = MenuItemConverter.getFoundationCallback(eventHandler);
        nsMenuItem.setTarget(foundationCallback.getTarget());
        nsMenuItem.setAction(foundationCallback.getSelector());
        MenuItemConverter.registerCallbackForCleanup(menuItem, foundationCallback);
    }

    private static void registerCallbackForCleanup(MenuItem menuItem, FoundationCallback foundationCallback) {
        if (foundationCallback != VOID_CALLBACK) {
            NSCleaner.register((Object)menuItem, foundationCallback);
        }
    }

    private static NSMenuItem createNsMenuItem(MenuItem menuItem, FoundationCallback foundationCallback) {
        String text = Optional.ofNullable(menuItem.getText()).orElse("");
        NSMenuItem nsMenuItem = NSMenuItem.alloc().initWithTitle(text, foundationCallback.getSelector(), MenuItemConverter.toKeyEquivalentString(menuItem.getAccelerator()));
        nsMenuItem.setTarget(foundationCallback.getTarget());
        return nsMenuItem;
    }

    private static FoundationCallback getFoundationCallback(EventHandler<ActionEvent> action) {
        if (action == null) {
            return VOID_CALLBACK;
        }
        return FoundationCallbackRegistry.registerCallback(id -> action.handle(new ActionEvent()));
    }

    private static String toKeyEquivalentString(KeyCombination accelerator) {
        if (accelerator == null) {
            return "";
        }
        return MenuItemConverter.keyEquivalent(accelerator);
    }

    private static String keyEquivalent(KeyCombination accelerator) {
        if (accelerator instanceof KeyCodeCombination) {
            return ((KeyCodeCombination)accelerator).getCode().getChar().toLowerCase();
        }
        return "";
    }

    private static int toKeyEventModifierFlags(KeyCombination accelerator) {
        int modifiers = 0;
        if (accelerator == null) {
            return modifiers;
        }
        if (accelerator.getShift() == KeyCombination.ModifierValue.DOWN) {
            modifiers |= 0x20000;
        }
        if (accelerator.getAlt() == KeyCombination.ModifierValue.DOWN) {
            modifiers |= 0x80000;
        }
        if (accelerator.getMeta() == KeyCombination.ModifierValue.DOWN) {
            modifiers |= 0x100000;
        }
        if (accelerator.getControl() == KeyCombination.ModifierValue.DOWN) {
            modifiers |= 0x40000;
        }
        return modifiers;
    }
}

