/*
 * Decompiled with CFR 0.152.
 */
package com.sqlines.studio.boot.config;

import com.sqlines.studio.properties.PropertiesManager;
import com.sqlines.studio.resource.ConversionModes;
import com.sqlines.studio.resource.HighlighterKeywords;
import com.sqlines.studio.resource.ResourceLoader;
import com.sqlines.studio.resource.StringResource;
import com.sqlines.studio.resource.UIResource;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
public class ResourceConfiguration {
    @Autowired
    private ConfigurableApplicationContext context;

    @Bean
    public ConversionModes conversionModes() {
        List<String> sourceModes = ResourceLoader.loadSourceModes();
        List<String> targetModes = ResourceLoader.loadTargetModes();
        Map<String, String> cmdModes = ResourceLoader.loadCmdModes();
        return new ConversionModes(cmdModes, sourceModes, targetModes);
    }

    @Bean
    @Scope(value="prototype")
    public StringResource sqlinesPath() {
        Predicate<String> isWin = path -> path.toLowerCase().startsWith("windows");
        Object path2 = PropertiesManager.get("APP_DIR");
        path2 = (String)path2 + (isWin.test(PropertiesManager.get("os.name")) ? "/sqlines.exe" : "/sqlines");
        return new StringResource((String)path2);
    }

    @Bean
    public Supplier<String> sqlinesPathSupplier() {
        return () -> this.context.getBean("sqlinesPath", StringResource.class).getString();
    }

    @Bean
    @Scope(value="prototype")
    public StringResource currentDir() {
        String dir = PropertiesManager.get("CURR_DIR");
        return new StringResource(dir);
    }

    @Bean
    public Supplier<String> currentDirSupplier() {
        return () -> this.context.getBean("currentDir", StringResource.class).getString();
    }

    @Bean
    @Scope(value="prototype")
    public StringResource licensePath() {
        String path = PropertiesManager.get("APP_DIR", "null") + "/license.txt";
        return new StringResource(path);
    }

    @Bean
    public Supplier<String> licensePathSupplier() {
        return () -> this.context.getBean("licensePath", StringResource.class).getString();
    }

    @Bean
    public HighlighterKeywords highlighterKeywords() {
        String[] keywords = ResourceLoader.loadKeywords();
        return new HighlighterKeywords(keywords);
    }

    @Bean
    public UIResource sqlinesIcon() {
        String icon = ResourceLoader.loadSqlinesIcon();
        return new UIResource(icon);
    }

    @Bean
    public UIResource openTabIcon() {
        String icon = ResourceLoader.loadOpenTabIcon();
        return new UIResource(icon);
    }

    @Bean
    public UIResource openFileIcon() {
        String icon = ResourceLoader.loadOpenFileIcon();
        return new UIResource(icon);
    }

    @Bean
    public UIResource saveFileIcon() {
        String icon = ResourceLoader.loadSaveFileIcon();
        return new UIResource(icon);
    }

    @Bean
    public UIResource runIcon() {
        String icon = ResourceLoader.loadRunFileIcon();
        return new UIResource(icon);
    }

    @Bean
    public UIResource errorIcon() {
        String icon = ResourceLoader.loadErrorFileIcon();
        return new UIResource(icon);
    }

    @Bean
    public UIResource mainWindowLightStylesheets() {
        String icon = ResourceLoader.loadMainLightStyles();
        return new UIResource(icon);
    }

    @Bean
    public UIResource mainWindowDarkStylesheets() {
        String icon = ResourceLoader.loadMainDarkStyles();
        return new UIResource(icon);
    }

    @Bean
    public UIResource settingsWindowLightStylesheets() {
        String icon = ResourceLoader.loadSettingLightStyles();
        return new UIResource(icon);
    }

    @Bean
    public UIResource settingsWindowDarkStylesheets() {
        String icon = ResourceLoader.loadSettingDarkStyles();
        return new UIResource(icon);
    }
}

