/*
 * Decompiled with CFR 0.152.
 */
package com.sqlines.studio.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.function.Consumer;

public class ResourceLoader {
    private ResourceLoader() {
    }

    public static List<String> loadSourceModes() {
        String data = ResourceLoader.loadResource("source-modes.txt");
        return ResourceLoader.extractRawModes(data);
    }

    private static String loadResource(String name) {
        String errorMsg2;
        block9: {
            InputStream stream = ResourceLoader.class.getResourceAsStream("/" + name);
            try {
                if (stream == null) {
                    String errorMsg2 = "File not found in application resources: " + name;
                    throw new IllegalStateException(errorMsg2);
                }
                errorMsg2 = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
                if (stream == null) break block9;
            }
            catch (Throwable errorMsg2) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable) {
                            errorMsg2.addSuppressed(throwable);
                        }
                    }
                    throw errorMsg2;
                }
                catch (IOException exc) {
                    String errorMsg3 = "Cannot read resource: " + name;
                    throw new IllegalStateException(errorMsg3, exc);
                }
            }
            stream.close();
        }
        return errorMsg2;
    }

    private static List<String> extractRawModes(String data) {
        ArrayList<String> modes = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(data, "\n");
        while (tokenizer.hasMoreTokens()) {
            String word = tokenizer.nextToken();
            int endIndex = word.indexOf(58);
            modes.add(word.substring(0, endIndex));
        }
        return modes;
    }

    public static List<String> loadTargetModes() {
        String data = ResourceLoader.loadResource("target-modes.txt");
        return ResourceLoader.extractRawModes(data);
    }

    public static Map<String, String> loadCmdModes() {
        String sourceModes = ResourceLoader.loadResource("source-modes.txt");
        String targetModes = ResourceLoader.loadResource("target-modes.txt");
        Map<String, String> modes = ResourceLoader.extractCmdModes(sourceModes);
        modes.putAll(ResourceLoader.extractCmdModes(targetModes));
        return modes;
    }

    private static Map<String, String> extractCmdModes(String modes) {
        StringTokenizer tokenizer = new StringTokenizer(modes, "\n");
        HashMap<String, String> cmdModes = new HashMap<String, String>();
        Consumer<String> addItem = data -> {
            int endIndex = data.indexOf(58);
            String key = data.substring(0, endIndex);
            String value = data.substring(endIndex + 1);
            cmdModes.put(key, value);
        };
        while (tokenizer.hasMoreTokens()) {
            addItem.accept(tokenizer.nextToken());
        }
        return cmdModes;
    }

    public static String[] loadKeywords() {
        String data = ResourceLoader.loadResource("keywords.txt");
        return ResourceLoader.extractKeywords(data);
    }

    private static String[] extractKeywords(String keywords) {
        StringTokenizer tokenizer = new StringTokenizer(keywords, ", ");
        LinkedList<String> words = new LinkedList<String>();
        while (tokenizer.hasMoreTokens()) {
            String word = tokenizer.nextToken().replace('\n', ' ').trim();
            words.add(word);
        }
        words.removeIf(String::isEmpty);
        String[] wordsArray = new String[words.size()];
        words.toArray(wordsArray);
        return wordsArray;
    }

    public static String loadMainLightStyles() {
        return ResourceLoader.loadUIResource("styles/main-light.css");
    }

    private static String loadUIResource(String name) {
        URL url = ResourceLoader.class.getResource("/" + name);
        if (url == null) {
            String errorMsg = "File not found in application resources: " + name;
            throw new IllegalStateException(errorMsg);
        }
        return url.toExternalForm();
    }

    public static String loadMainDarkStyles() {
        return ResourceLoader.loadUIResource("styles/main-dark.css");
    }

    public static String loadSettingLightStyles() {
        return ResourceLoader.loadUIResource("styles/settings-light.css");
    }

    public static String loadSettingDarkStyles() {
        return ResourceLoader.loadUIResource("styles/settings-dark.css");
    }

    public static String loadSqlinesIcon() {
        return ResourceLoader.loadUIResource("icons/logo.png");
    }

    public static String loadOpenTabIcon() {
        return ResourceLoader.loadUIResource("icons/open-tab.png");
    }

    public static String loadOpenFileIcon() {
        return ResourceLoader.loadUIResource("icons/open-file.png");
    }

    public static String loadSaveFileIcon() {
        return ResourceLoader.loadUIResource("icons/save-file.png");
    }

    public static String loadRunFileIcon() {
        return ResourceLoader.loadUIResource("icons/run.png");
    }

    public static String loadErrorFileIcon() {
        return ResourceLoader.loadUIResource("icons/error.png");
    }
}

