/*
 * Decompiled with CFR 0.152.
 */
package com.sqlines.studio.view;

import com.sqlines.studio.view.BaseView;
import javafx.collections.ObservableList;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;

public abstract class AbstractWindow
extends Stage
implements BaseView {
    private Scene scene;
    private BaseView.Appearance appearance = BaseView.Appearance.NONE;
    private String lightStylesheets;
    private String darkStylesheets;

    @Override
    public final BaseView.Appearance getAppearance() {
        return this.appearance;
    }

    @Override
    public final void setAppearance(BaseView.Appearance appearance) {
        if (this.scene == null) {
            throw new IllegalStateException("Root node not set");
        }
        if (appearance == BaseView.Appearance.LIGHT) {
            this.setLightAppearance();
        } else if (appearance == BaseView.Appearance.DARK) {
            this.setDarkAppearance();
        } else if (appearance == BaseView.Appearance.NONE) {
            this.clearAppearance();
        }
    }

    private void setLightAppearance() {
        if (this.lightStylesheets == null) {
            throw new IllegalStateException("Light styles not set");
        }
        ObservableList<String> stylesheets = this.scene.getStylesheets();
        stylesheets.clear();
        stylesheets.add(this.lightStylesheets);
        this.appearance = BaseView.Appearance.LIGHT;
    }

    private void setDarkAppearance() {
        if (this.darkStylesheets == null) {
            throw new IllegalStateException("Dark styles not set");
        }
        ObservableList<String> stylesheets = this.scene.getStylesheets();
        stylesheets.clear();
        stylesheets.add(this.darkStylesheets);
        this.appearance = BaseView.Appearance.DARK;
    }

    private void clearAppearance() {
        this.scene.getStylesheets().clear();
    }

    public final String getLightStylesheets() {
        if (this.lightStylesheets == null) {
            throw new IllegalStateException("Light styles not set");
        }
        return this.lightStylesheets;
    }

    public final String getDarkStylesheets() {
        if (this.darkStylesheets == null) {
            throw new IllegalStateException("Dark styles not set");
        }
        return this.darkStylesheets;
    }

    public final void setLightStylesheets(String filePath) {
        this.lightStylesheets = filePath;
    }

    public final void setDarkStylesheets(String filePath) {
        this.darkStylesheets = filePath;
    }

    protected final void setRoot(Parent node) {
        this.scene = new Scene(node);
        this.scene.setRoot(node);
        this.setScene(this.scene);
    }
}

