/*
 * Decompiled with CFR 0.152.
 */
package com.sqlines.studio.view.settings;

import com.sqlines.studio.view.AbstractWindow;
import com.sqlines.studio.view.BaseView;
import com.sqlines.studio.view.ErrorWindow;
import com.sqlines.studio.view.settings.SettingsWindowView;
import com.sqlines.studio.view.settings.event.ChangeLicenseEvent;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.stage.DirectoryChooser;
import javafx.stage.StageStyle;

public class SettingsWindow
extends AbstractWindow
implements SettingsWindowView {
    private final Supplier<ErrorWindow> errorWindowSupplier;
    private EventHandler<ChangeLicenseEvent> licenseEventHandler;
    private final ChoiceBox<String> dirsBox = new ChoiceBox();
    private final Button addDirButton = new Button();
    private final Button setDefaultsButton = new Button();
    private final ChoiceBox<String> appearanceBox = new ChoiceBox();
    private final RadioButton statusBarButton = new RadioButton();
    private final RadioButton targetFieldButton = new RadioButton();
    private final RadioButton wrappingButton = new RadioButton();
    private final RadioButton highlighterButton = new RadioButton();
    private final RadioButton lineNumbersButton = new RadioButton();
    private final Text licenseInfo = new Text();
    private final TextField regNameField = new TextField();
    private final TextField regNumberField = new TextField();
    private final Button changeButton = new Button();

    public SettingsWindow(Supplier<ErrorWindow> errorWindowSupplier) {
        this.errorWindowSupplier = errorWindowSupplier;
        this.setUpScene();
        this.setUpWindow();
    }

    private void setUpScene() {
        TabPane tabPane = new TabPane();
        this.setRoot(tabPane);
        this.setUpTabPane(tabPane);
    }

    private void setUpTabPane(TabPane tabPane) {
        tabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        tabPane.getSelectionModel().selectedIndexProperty().addListener(this::tabIndexChanged);
        tabPane.getTabs().add(new Tab("General", this.makeGeneralTab()));
        tabPane.getTabs().add(new Tab("Appearance", this.makeAppearanceTab()));
        tabPane.getTabs().add(new Tab("License", this.makeLicenseTab()));
    }

    private void tabIndexChanged(ObservableValue<? extends Number> observable, Number oldIndex, Number newIndex) {
        int tabIndex = newIndex.intValue();
        if (tabIndex == 0) {
            this.setGeneralTabSize();
        } else if (tabIndex == 1) {
            this.setEditorTabSize();
        } else if (tabIndex == 2) {
            this.setLicenseTabSize();
        }
    }

    private void setGeneralTabSize() {
        this.setWidth(320.0);
        this.setHeight(180.0);
    }

    private void setEditorTabSize() {
        this.setWidth(320.0);
        this.setHeight(240.0);
    }

    private void setLicenseTabSize() {
        this.setWidth(320.0);
        this.setHeight(220.0);
    }

    private VBox makeGeneralTab() {
        this.setUpGeneralTabItems();
        return this.createGeneralTabLayout();
    }

    private void setUpGeneralTabItems() {
        this.addDirButton.setText("Add new");
        this.setDefaultsButton.setText("Set defaults");
    }

    private VBox createGeneralTabLayout() {
        GridPane topLayout = new GridPane();
        topLayout.setHgap(10.0);
        topLayout.setVgap(10.0);
        topLayout.add(new Text("Working directory:"), 0, 0);
        topLayout.add(this.dirsBox, 1, 0);
        topLayout.add(this.addDirButton, 1, 1);
        VBox mainLayout = new VBox(topLayout, this.setDefaultsButton);
        mainLayout.setPadding(new Insets(10.0, 15.0, 10.0, 15.0));
        mainLayout.setSpacing(10.0);
        return mainLayout;
    }

    private VBox makeAppearanceTab() {
        this.setUpAppearanceTabItems();
        return this.createAppearanceTabLayout();
    }

    private void setUpAppearanceTabItems() {
        this.statusBarButton.setText("Status bar");
        this.targetFieldButton.setText("Always show target field");
        this.wrappingButton.setText("Wrap lines to editor width");
        this.highlighterButton.setText("Highlighter");
        this.lineNumbersButton.setText("Line numbers");
    }

    private VBox createAppearanceTabLayout() {
        GridPane topLayout = new GridPane();
        topLayout.setVgap(10.0);
        topLayout.setHgap(10.0);
        topLayout.add(new Text("Appearance:"), 0, 0);
        topLayout.add(this.appearanceBox, 1, 0);
        VBox mainLayout = new VBox(topLayout, this.statusBarButton, this.targetFieldButton, this.wrappingButton, this.highlighterButton, this.lineNumbersButton);
        mainLayout.setPadding(new Insets(10.0, 15.0, 10.0, 15.0));
        mainLayout.setSpacing(10.0);
        return mainLayout;
    }

    private VBox makeLicenseTab() {
        this.setUpLicenseTabItems();
        return this.createLicenseTabLayout();
    }

    private void setUpLicenseTabItems() {
        this.regNameField.setPromptText("Enter registration name");
        this.regNumberField.setPromptText("Enter registration number");
        this.changeButton.setText("Commit change");
        this.changeButton.setOnAction(event -> this.handleLicenceChangeEvent());
    }

    private void handleLicenceChangeEvent() {
        ChangeLicenseEvent clickedEvent = new ChangeLicenseEvent(this.regNameField.getText(), this.regNumberField.getText());
        this.changeButton.fireEvent(clickedEvent);
        if (this.licenseEventHandler != null) {
            this.licenseEventHandler.handle(clickedEvent);
        }
    }

    private VBox createLicenseTabLayout() {
        VBox topLayout = new VBox(this.licenseInfo);
        topLayout.setPadding(new Insets(10.0, 0.0, 5.0, 0.0));
        VBox mainLayout = new VBox(topLayout, this.regNameField, this.regNumberField, this.changeButton);
        mainLayout.setPadding(new Insets(10.0, 15.0, 10.0, 15.0));
        mainLayout.setSpacing(10.0);
        return mainLayout;
    }

    private void setUpWindow() {
        this.initStyle(StageStyle.UTILITY);
        this.setTitle("Preferences");
        this.setWidth(320.0);
        this.setHeight(180.0);
        this.setResizable(false);
    }

    @Override
    public void showError(String cause, String errorMsg) {
        ErrorWindow window = this.errorWindowSupplier.get();
        this.setStylesheets(window);
        window.setError(cause, errorMsg);
        window.show();
    }

    private void setStylesheets(AbstractWindow window) {
        BaseView.Appearance appearance = this.getAppearance();
        if (appearance == BaseView.Appearance.LIGHT) {
            window.setLightStylesheets(this.getLightStylesheets());
        } else if (appearance == BaseView.Appearance.DARK) {
            window.setDarkStylesheets(this.getDarkStylesheets());
        }
        window.setAppearance(appearance);
    }

    @Override
    public Optional<String> choseDirectoryToAdd() {
        DirectoryChooser chooser = new DirectoryChooser();
        File dir = chooser.showDialog(this);
        return Optional.ofNullable(dir).map(File::getAbsolutePath);
    }

    @Override
    public void addDirectory(String dir) {
        if (dir.isEmpty()) {
            throw new IllegalArgumentException("Working directory is empty");
        }
        this.dirsBox.getItems().add(dir);
    }

    @Override
    public final void setWorkingDirectories(List<String> dirs) {
        if (dirs.isEmpty()) {
            throw new IllegalArgumentException("List of working directories is empty");
        }
        this.dirsBox.getItems().clear();
        this.dirsBox.getItems().addAll((Collection<String>)dirs);
        this.dirsBox.getSelectionModel().select(0);
    }

    @Override
    public final void setAppearances(List<String> appearances) {
        if (appearances.isEmpty()) {
            throw new IllegalArgumentException("List of appearances is empty");
        }
        this.appearanceBox.getItems().addAll((Collection<String>)appearances);
        this.appearanceBox.getSelectionModel().select(0);
    }

    @Override
    public void selectDirectory(String dir) {
        if (!this.dirsBox.getItems().contains(dir)) {
            throw new IllegalArgumentException("Such a directory does not exist: " + dir);
        }
        this.dirsBox.getSelectionModel().select(dir);
    }

    @Override
    public void selectAppearance(BaseView.Appearance appearance) {
        if (appearance == BaseView.Appearance.LIGHT) {
            this.appearanceBox.getSelectionModel().select(0);
        } else if (appearance == BaseView.Appearance.DARK) {
            this.appearanceBox.getSelectionModel().select(1);
        }
    }

    @Override
    public void setLicenseInfo(String info) {
        this.licenseInfo.setText(info);
    }

    @Override
    public void setStatusBarSelected(boolean isSelected) {
        this.statusBarButton.setSelected(isSelected);
    }

    @Override
    public void setTargetFieldSelected(boolean isSelected) {
        this.targetFieldButton.setSelected(isSelected);
    }

    @Override
    public void setWrappingSelected(boolean isSelected) {
        this.wrappingButton.setSelected(isSelected);
    }

    @Override
    public void setHighlighterSelected(boolean isSelected) {
        this.highlighterButton.setSelected(isSelected);
    }

    @Override
    public void setLineNumbersSelected(boolean isSelected) {
        this.lineNumbersButton.setSelected(isSelected);
    }

    @Override
    public void addAppearanceChangeListener(ChangeListener<String> listener) {
        this.appearanceBox.getSelectionModel().selectedItemProperty().addListener(listener);
    }

    @Override
    public void addDirChangeListener(ChangeListener<String> listener) {
        this.dirsBox.getSelectionModel().selectedItemProperty().addListener(listener);
    }

    @Override
    public void setOnAddDirAction(EventHandler<ActionEvent> action) {
        this.addDirButton.setOnAction(action);
    }

    @Override
    public void setOnSetDefaultsAction(EventHandler<ActionEvent> action) {
        this.setDefaultsButton.setOnAction(action);
    }

    @Override
    public void setOnStatusBarAction(EventHandler<ActionEvent> action) {
        this.statusBarButton.setOnAction(action);
    }

    @Override
    public void setOnTargetFieldAction(EventHandler<ActionEvent> action) {
        this.targetFieldButton.setOnAction(action);
    }

    @Override
    public void setOnWrappingAction(EventHandler<ActionEvent> action) {
        this.wrappingButton.setOnAction(action);
    }

    @Override
    public void setOnHighlighterAction(EventHandler<ActionEvent> action) {
        this.highlighterButton.setOnAction(action);
    }

    @Override
    public void setOnLineNumbersAction(EventHandler<ActionEvent> action) {
        this.lineNumbersButton.setOnAction(action);
    }

    @Override
    public void setOnChangeLicenseAction(EventHandler<ChangeLicenseEvent> action) {
        this.licenseEventHandler = action;
    }
}

