/*
 * Decompiled with CFR 0.152.
 */
package de.jangassen.util;

import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;

public final class MenuBarUtils {
    private MenuBarUtils() {
    }

    public static MenuBar createMenuBar(ObservableList<Menu> menus) {
        MenuBar bar = new MenuBar();
        bar.setUseSystemMenuBar(true);
        Bindings.bindContentBidirectional(bar.getMenus(), menus);
        return bar;
    }

    public static void removeExistingMenuBar(ObservableList<Node> children) {
        children.removeAll(children.stream().filter(MenuBar.class::isInstance).collect(Collectors.toList()));
    }

    public static void setMenuBar(Stage stage, MenuBar menuBar) {
        ObservableList<Node> children;
        Scene scene = stage.getScene();
        if (scene != null && (children = MenuBarUtils.getChildren(scene.getRoot())) != null) {
            MenuBarUtils.setMenuBar(children, menuBar);
        }
    }

    private static ObservableList<Node> getChildren(Parent parent) {
        if (parent instanceof Pane) {
            return ((Pane)parent).getChildren();
        }
        if (parent instanceof Group) {
            return ((Group)parent).getChildren();
        }
        return null;
    }

    public static void setMenuBar(Pane pane, MenuBar menuBar) {
        MenuBarUtils.setMenuBar(pane.getChildren(), menuBar);
    }

    private static void setMenuBar(ObservableList<Node> children, MenuBar menuBar) {
        MenuBarUtils.replaceMenuBar(children, MenuBarUtils.createMenuBar(MenuBarUtils.extractSubMenus(menuBar)));
    }

    private static void replaceMenuBar(ObservableList<Node> children, MenuBar createMenuBar) {
        MenuBarUtils.removeExistingMenuBar(children);
        children.add(createMenuBar);
    }

    private static ObservableList<Menu> extractSubMenus(MenuBar bar) {
        return new FilteredList<Menu>(bar.getMenus(), menu -> bar.getMenus().indexOf(menu) > 0);
    }
}

