/*
 * Decompiled with CFR 0.152.
 */
package com.sqlines.studio.boot.config;

import com.sqlines.studio.model.converter.Converter;
import com.sqlines.studio.model.converter.ConverterImpl;
import com.sqlines.studio.model.filemanager.FileManager;
import com.sqlines.studio.model.filemanager.FileManagerImpl;
import com.sqlines.studio.model.license.License;
import com.sqlines.studio.model.license.LicenseFile;
import com.sqlines.studio.model.sqlines.SqlinesRunner;
import com.sqlines.studio.model.sqlines.SqlinesRunnerImp;
import com.sqlines.studio.model.sqlines.process.ProcessStarter;
import com.sqlines.studio.model.sqlines.process.ProcessStarterImpl;
import com.sqlines.studio.model.tabs.LinkedListTabs;
import com.sqlines.studio.model.tabs.ObservableTabs;
import com.sqlines.studio.resource.ConversionModes;
import com.sqlines.studio.util.Serialization;
import com.sqlines.studio.util.file.FileCreator;
import com.sqlines.studio.util.file.FileDeleter;
import com.sqlines.studio.util.file.FileReader;
import com.sqlines.studio.util.file.FileStatsProvider;
import com.sqlines.studio.util.file.FileWriter;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ModelConfiguration {
    private static final Logger log = LogManager.getLogger(ModelConfiguration.class);

    @Bean
    public ProcessStarter processStarter() {
        return new ProcessStarterImpl();
    }

    @Bean
    public SqlinesRunner sqlinesRunner(ProcessStarter starter, FileStatsProvider fileStatsProvider, @Qualifier(value="sqlinesPathSupplier") Supplier<String> supplier) {
        return new SqlinesRunnerImp(starter, supplier, fileStatsProvider);
    }

    @Bean
    public Converter converter(ConversionModes cmdModes, SqlinesRunner sqlines, @Qualifier(value="currentDirSupplier") Supplier<String> supplier, FileReader fileReader, FileWriter fileWriter, FileCreator fileCreator, FileDeleter fileDeleter, FileStatsProvider fileStatsProvider) {
        return new ConverterImpl(cmdModes, sqlines, supplier, fileReader, fileWriter, fileCreator, fileDeleter, fileStatsProvider);
    }

    @Bean
    public License license(SqlinesRunner sqlines, FileWriter fileWriter, FileCreator fileCreator, FileDeleter fileDeleter, FileStatsProvider fileStatsProvider, @Qualifier(value="licensePathSupplier") Supplier<String> supplier) {
        return new LicenseFile(sqlines, fileWriter, fileCreator, fileDeleter, fileStatsProvider, supplier);
    }

    @Bean
    public FileManager fileManager(FileReader fileReader, FileWriter fileWriter, FileStatsProvider fileStatsProvider) {
        try {
            FileManagerImpl object = Serialization.deserializeFileManager();
            object.setFileReader(fileReader);
            object.setFileWriter(fileWriter);
            object.setFileStatsProvider(fileStatsProvider);
            log.info("File manager deserialized. Files: " + object.countFiles());
            return object;
        }
        catch (Exception exc) {
            log.info("File manager deserialization error: " + exc.getMessage());
            return new FileManagerImpl(fileReader, fileWriter, fileStatsProvider);
        }
    }

    @Bean
    public ObservableTabs observableTabs() {
        try {
            LinkedListTabs object = Serialization.deserializeTabs();
            log.info("Tabs deserialized. Tabs: " + object.size());
            return object;
        }
        catch (Exception exc) {
            log.info("Tabs deserialization error: " + exc.getMessage());
            return new LinkedListTabs();
        }
    }
}

