/*
 * Decompiled with CFR 0.152.
 */
package com.sqlines.studio.boot.config;

import com.sqlines.studio.resource.ConversionModes;
import com.sqlines.studio.resource.HighlighterKeywords;
import com.sqlines.studio.resource.UIResource;
import com.sqlines.studio.view.ErrorWindow;
import com.sqlines.studio.view.mainwindow.AboutWindow;
import com.sqlines.studio.view.mainwindow.CentralNode;
import com.sqlines.studio.view.mainwindow.MainMenuBar;
import com.sqlines.studio.view.mainwindow.MainStatusBar;
import com.sqlines.studio.view.mainwindow.MainToolBar;
import com.sqlines.studio.view.mainwindow.MainWindow;
import com.sqlines.studio.view.mainwindow.MainWindowSettingsView;
import com.sqlines.studio.view.mainwindow.MainWindowView;
import com.sqlines.studio.view.mainwindow.editor.CodeEditor;
import com.sqlines.studio.view.mainwindow.editor.EditorContextMenu;
import com.sqlines.studio.view.mainwindow.editor.Highlighter;
import com.sqlines.studio.view.settings.SettingsWindow;
import com.sqlines.studio.view.settings.SettingsWindowView;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
public class ViewConfiguration {
    @Autowired
    private ConfigurableApplicationContext context;

    @Bean
    public Highlighter highlighter(HighlighterKeywords keywords) {
        return new Highlighter(keywords);
    }

    @Bean
    @Scope(value="prototype")
    public EditorContextMenu contextMenu() {
        return new EditorContextMenu();
    }

    @Bean
    @Scope(value="prototype")
    public CodeEditor codeEditor(Highlighter highlighter, EditorContextMenu contextMenu) {
        return new CodeEditor(highlighter, contextMenu);
    }

    @Bean
    @Scope(value="prototype")
    public CentralNode centralNode(CodeEditor sourceEditor, CodeEditor targetEditor) {
        return new CentralNode(sourceEditor, targetEditor);
    }

    @Bean
    @Scope(value="prototype")
    public MainMenuBar mainMenuBar() {
        return new MainMenuBar();
    }

    @Bean
    @Scope(value="prototype")
    public MainStatusBar mainStatusBar() {
        return new MainStatusBar();
    }

    @Bean
    @Scope(value="prototype")
    public MainToolBar mainToolBar(@Qualifier(value="openTabIcon") UIResource openTabIcon, @Qualifier(value="openFileIcon") UIResource openFileIcon, @Qualifier(value="saveFileIcon") UIResource saveFileIcon, @Qualifier(value="runIcon") UIResource runIcon) {
        return new MainToolBar(openTabIcon, openFileIcon, saveFileIcon, runIcon);
    }

    @Bean
    @Scope(value="prototype")
    public AboutWindow aboutWindow(@Qualifier(value="sqlinesIcon") UIResource logo) {
        return new AboutWindow(logo);
    }

    @Bean
    @Scope(value="prototype")
    public ErrorWindow errorWindow(@Qualifier(value="errorIcon") UIResource image) {
        return new ErrorWindow(image);
    }

    @Bean
    public Supplier<ErrorWindow> errorWindowSupplier() {
        return () -> this.context.getBean(ErrorWindow.class);
    }

    @Bean
    public Supplier<AboutWindow> abourWindowSupplier() {
        return () -> this.context.getBean(AboutWindow.class);
    }

    @Bean
    public Supplier<CentralNode> centralNodeSupplier() {
        return () -> this.context.getBean(CentralNode.class);
    }

    @Bean
    public MainWindowView mainWindowView(@Qualifier(value="mainWindow") MainWindow mainWindow) {
        return mainWindow;
    }

    @Bean
    public MainWindow mainWindow(MainToolBar toolBar, MainMenuBar menuBar, MainStatusBar statusBar, ConversionModes modes, Supplier<ErrorWindow> errorWindowSupplier, Supplier<AboutWindow> aboutWindowSupplier, Supplier<CentralNode> centralNodeSupplier, @Qualifier(value="mainWindowLightStylesheets") UIResource lightStyles, @Qualifier(value="mainWindowDarkStylesheets") UIResource darkStyles) {
        MainWindow mainWindow = new MainWindow(toolBar, menuBar, statusBar, errorWindowSupplier, aboutWindowSupplier, centralNodeSupplier);
        mainWindow.setConversionModes(modes.getSourceModes(), modes.getTargetModes());
        mainWindow.setLightStylesheets(lightStyles.getUrl());
        mainWindow.setDarkStylesheets(darkStyles.getUrl());
        return mainWindow;
    }

    @Bean
    public MainWindowSettingsView mainWindowSettingsView(@Qualifier(value="mainWindow") MainWindow mainWindow) {
        return mainWindow;
    }

    @Bean
    public SettingsWindowView settingsWindowView(Supplier<ErrorWindow> errorWindowSupplier, @Qualifier(value="settingsWindowLightStylesheets") UIResource lightStyles, @Qualifier(value="settingsWindowDarkStylesheets") UIResource darkStyles) {
        SettingsWindow settingsWindow = new SettingsWindow(errorWindowSupplier);
        settingsWindow.setLightStylesheets(lightStyles.getUrl());
        settingsWindow.setDarkStylesheets(darkStyles.getUrl());
        return settingsWindow;
    }
}

