/*
 * Decompiled with CFR 0.152.
 */
package com.sqlines.studio.model.tabs;

import com.sqlines.studio.model.tabs.ObservableTabs;
import com.sqlines.studio.model.tabs.Tab;
import com.sqlines.studio.model.tabs.listener.FilePathChangeListener;
import com.sqlines.studio.model.tabs.listener.ModeChangeListener;
import com.sqlines.studio.model.tabs.listener.TabIndexChangeListener;
import com.sqlines.studio.model.tabs.listener.TabTitleChangeListener;
import com.sqlines.studio.model.tabs.listener.TabsChangeListener;
import com.sqlines.studio.model.tabs.listener.TextChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Spliterator;
import java.util.function.Consumer;

public class LinkedListTabs
implements ObservableTabs {
    private static final long serialVersionUID = 349837438743794L;
    private List<Tab> tabs = new LinkedList<Tab>();
    private int currTabIndex = -1;
    private transient List<TabsChangeListener> tabsListeners = new ArrayList<TabsChangeListener>(5);
    private transient List<TabIndexChangeListener> tabIndexListeners = new ArrayList<TabIndexChangeListener>(5);
    private transient List<TabTitleChangeListener> titleListeners = new ArrayList<TabTitleChangeListener>(5);
    private transient List<TextChangeListener> sourceTextListeners = new ArrayList<TextChangeListener>(5);
    private transient List<TextChangeListener> targetTextListeners = new ArrayList<TextChangeListener>(5);
    private transient List<ModeChangeListener> sourceModeListeners = new ArrayList<ModeChangeListener>(5);
    private transient List<ModeChangeListener> targetModeListeners = new ArrayList<ModeChangeListener>(5);
    private transient List<FilePathChangeListener> sourcePathListeners = new ArrayList<FilePathChangeListener>(5);
    private transient List<FilePathChangeListener> targetPathListeners = new ArrayList<FilePathChangeListener>(5);

    @Override
    public synchronized void add(int index, Tab tab) {
        this.tabs.add(index, tab);
        this.notifyTabAddListeners(index);
    }

    private void notifyTabAddListeners(int tabIndex) {
        TabsChangeListener.Change added = TabsChangeListener.Change.builder().changeType(TabsChangeListener.Change.ChangeType.TAB_ADDED).tabIndex(tabIndex).build();
        this.tabsListeners.forEach((? super T listener) -> listener.onChange(added));
    }

    @Override
    public synchronized Tab remove(int index) {
        Tab tab = this.tabs.remove(index);
        this.notifyTabRemoveListeners(index);
        return tab;
    }

    private void notifyTabRemoveListeners(int tabIndex) {
        TabsChangeListener.Change removed = TabsChangeListener.Change.builder().changeType(TabsChangeListener.Change.ChangeType.TAB_REMOVED).tabIndex(tabIndex).build();
        this.tabsListeners.forEach((? super T listener) -> listener.onChange(removed));
    }

    @Override
    public synchronized void clear() {
        int tabsNumber = this.tabs.size();
        this.tabs.clear();
        this.currTabIndex = -1;
        for (int i = 0; i < tabsNumber; ++i) {
            this.notifyTabRemoveListeners(i);
        }
    }

    @Override
    public synchronized Tab get(int index) {
        return this.tabs.get(index);
    }

    @Override
    public synchronized int size() {
        return this.tabs.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.tabs.isEmpty();
    }

    @Override
    public synchronized boolean contains(Object tab) {
        return this.tabs.contains(tab);
    }

    @Override
    public synchronized void forEach(Consumer<? super Tab> action) {
        this.tabs.forEach(action);
    }

    @Override
    public synchronized Iterator<Tab> iterator() {
        return this.tabs.iterator();
    }

    @Override
    public synchronized Spliterator<Tab> spliterator() {
        return this.tabs.spliterator();
    }

    @Override
    public synchronized ListIterator<Tab> listIterator() {
        return this.tabs.listIterator();
    }

    @Override
    public synchronized ListIterator<Tab> listIterator(int index) {
        return this.tabs.listIterator(index);
    }

    @Override
    public synchronized Object[] toArray() {
        return this.tabs.toArray();
    }

    @Override
    public synchronized <T> T[] toArray(T[] arr) {
        return this.tabs.toArray(arr);
    }

    @Override
    public synchronized int indexOf(Object tab) {
        return this.tabs.indexOf(tab);
    }

    @Override
    public synchronized int lastIndexOf(Object tab) {
        return this.tabs.lastIndexOf(tab);
    }

    @Override
    public synchronized int getCurrTabIndex() {
        return this.currTabIndex;
    }

    @Override
    public synchronized void setCurrTabIndex(int tabIndex) {
        this.currTabIndex = tabIndex;
        this.tabIndexListeners.forEach((? super T listener) -> listener.changed(tabIndex));
    }

    @Override
    public synchronized void setTabTitle(String title, int tabIndex) {
        this.tabs.get(tabIndex).setTabTitle(title);
        this.titleListeners.forEach((? super T listener) -> listener.changed(title, tabIndex));
    }

    @Override
    public synchronized void setSourceText(String text, int tabIndex) {
        this.tabs.get(tabIndex).setSourceText(text);
        this.sourceTextListeners.forEach((? super T listener) -> listener.changed(text, tabIndex));
    }

    @Override
    public synchronized void setTargetText(String text, int tabIndex) {
        this.tabs.get(tabIndex).setTargetText(text);
        this.targetTextListeners.forEach((? super T listener) -> listener.changed(text, tabIndex));
    }

    @Override
    public synchronized void setSourceMode(String mode, int tabIndex) {
        this.tabs.get(tabIndex).setSourceMode(mode);
        this.sourceModeListeners.forEach((? super T listener) -> listener.changed(mode, tabIndex));
    }

    @Override
    public synchronized void setTargetMode(String mode, int tabIndex) {
        this.tabs.get(tabIndex).setTargetMode(mode);
        this.targetModeListeners.forEach((? super T listener) -> listener.changed(mode, tabIndex));
    }

    @Override
    public synchronized void setSourceFilePath(String filePath, int tabIndex) {
        this.tabs.get(tabIndex).setSourceFilePath(filePath);
        this.sourcePathListeners.forEach((? super T listener) -> listener.changed(filePath, tabIndex));
    }

    @Override
    public synchronized void setTargetFilePath(String filePath, int tabIndex) {
        this.tabs.get(tabIndex).setTargetFilePath(filePath);
        this.targetPathListeners.forEach((? super T listener) -> listener.changed(filePath, tabIndex));
    }

    @Override
    public synchronized void addTabsListener(TabsChangeListener listener) {
        this.tabsListeners.add(listener);
    }

    @Override
    public synchronized void removeTabsListener(TabsChangeListener listener) {
        this.tabsListeners.remove(listener);
    }

    @Override
    public synchronized void addTabIndexListener(TabIndexChangeListener listener) {
        this.tabIndexListeners.add(listener);
    }

    @Override
    public synchronized void removeTabIndexListener(TabIndexChangeListener listener) {
        this.tabIndexListeners.remove(listener);
    }

    @Override
    public synchronized void addTabTitleListener(TabTitleChangeListener listener) {
        this.titleListeners.add(listener);
    }

    @Override
    public synchronized void removeTabTitleListener(TabTitleChangeListener listener) {
        this.titleListeners.remove(listener);
    }

    @Override
    public synchronized void addSourceModeListener(ModeChangeListener listener) {
        this.sourceModeListeners.add(listener);
    }

    @Override
    public synchronized void removeSourceModeListener(ModeChangeListener listener) {
        this.sourceModeListeners.remove(listener);
    }

    @Override
    public synchronized void addTargetModeListener(ModeChangeListener listener) {
        this.targetModeListeners.add(listener);
    }

    @Override
    public synchronized void removeTargetModeListener(ModeChangeListener listener) {
        this.targetModeListeners.remove(listener);
    }

    @Override
    public synchronized void addSourceTextListener(TextChangeListener listener) {
        this.sourceTextListeners.add(listener);
    }

    @Override
    public synchronized void removeSourceTextListener(TextChangeListener listener) {
        this.sourceTextListeners.remove(listener);
    }

    @Override
    public synchronized void addTargetTextListener(TextChangeListener listener) {
        this.targetTextListeners.add(listener);
    }

    @Override
    public synchronized void removeTargetTextListener(TextChangeListener listener) {
        this.targetTextListeners.remove(listener);
    }

    @Override
    public synchronized void addSourceFilePathListener(FilePathChangeListener listener) {
        this.sourcePathListeners.add(listener);
    }

    @Override
    public synchronized void addTargetFilePathListener(FilePathChangeListener listener) {
        this.targetPathListeners.add(listener);
    }

    private void readObject(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        this.initFields();
        int tabsNumber = stream.readInt();
        for (int i = 0; i < tabsNumber; ++i) {
            Tab data = (Tab)stream.readObject();
            this.tabs.add(data);
        }
        this.currTabIndex = stream.readInt();
    }

    private void initFields() {
        this.tabsListeners = new ArrayList<TabsChangeListener>(5);
        this.tabIndexListeners = new ArrayList<TabIndexChangeListener>(5);
        this.titleListeners = new ArrayList<TabTitleChangeListener>(5);
        this.sourceTextListeners = new ArrayList<TextChangeListener>(5);
        this.targetTextListeners = new ArrayList<TextChangeListener>(5);
        this.sourceModeListeners = new ArrayList<ModeChangeListener>(5);
        this.targetModeListeners = new ArrayList<ModeChangeListener>(5);
        this.sourcePathListeners = new ArrayList<FilePathChangeListener>(5);
        this.targetPathListeners = new ArrayList<FilePathChangeListener>(5);
        this.tabs = new LinkedList<Tab>();
        this.currTabIndex = -1;
    }

    private synchronized void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeInt(this.tabs.size());
        for (Tab data : this.tabs) {
            stream.writeObject(data);
        }
        stream.writeInt(this.currTabIndex);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LinkedListTabs)) {
            return false;
        }
        LinkedListTabs other = (LinkedListTabs)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCurrTabIndex() != other.getCurrTabIndex()) {
            return false;
        }
        List<Tab> this$tabs = this.tabs;
        List<Tab> other$tabs = other.tabs;
        return !(this$tabs == null ? other$tabs != null : !((Object)this$tabs).equals(other$tabs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LinkedListTabs;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCurrTabIndex();
        List<Tab> $tabs = this.tabs;
        result = result * 59 + ($tabs == null ? 43 : ((Object)$tabs).hashCode());
        return result;
    }

    public String toString() {
        return "LinkedListTabs(tabs=" + this.tabs + ", currTabIndex=" + this.getCurrTabIndex() + ", tabsListeners=" + this.tabsListeners + ", tabIndexListeners=" + this.tabIndexListeners + ", titleListeners=" + this.titleListeners + ", sourceTextListeners=" + this.sourceTextListeners + ", targetTextListeners=" + this.targetTextListeners + ", sourceModeListeners=" + this.sourceModeListeners + ", targetModeListeners=" + this.targetModeListeners + ", sourcePathListeners=" + this.sourcePathListeners + ", targetPathListeners=" + this.targetPathListeners + ")";
    }
}

