/*
 * Decompiled with CFR 0.152.
 */
package com.sqlines.studio.presenter;

import com.sqlines.studio.model.license.License;
import com.sqlines.studio.properties.PropertiesManager;
import com.sqlines.studio.view.BaseView;
import com.sqlines.studio.view.mainwindow.MainWindowSettingsView;
import com.sqlines.studio.view.settings.SettingsWindowView;
import com.sqlines.studio.view.settings.event.ChangeLicenseEvent;
import java.util.List;
import java.util.Optional;
import javafx.application.Platform;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SettingsPresenter {
    private static final Logger log = LogManager.getLogger(SettingsPresenter.class);
    private final License license;
    private final SettingsWindowView settingsWindow;
    private final MainWindowSettingsView mainWindow;
    private final List<? extends BaseView> windows;

    public SettingsPresenter(License license, SettingsWindowView settingsWindowView, MainWindowSettingsView mainWindowView) {
        this.license = license;
        this.settingsWindow = settingsWindowView;
        this.mainWindow = mainWindowView;
        this.windows = List.of(mainWindowView, settingsWindowView);
        this.init();
    }

    private void init() {
        this.setDefaults();
        this.initHandlers();
        this.loadProperties();
        this.checkLicense();
    }

    private void setDefaults() {
        String defaultDir = PropertiesManager.get("user.home") + "/sqlines";
        this.settingsWindow.setWorkingDirectories(List.of(defaultDir));
        this.settingsWindow.setAppearances(List.of("Light", "Dark"));
    }

    private void initHandlers() {
        this.initLicenseHandlers();
        this.initMainWindowHandlers();
        this.initSettingsWindowHandlers();
    }

    private void initLicenseHandlers() {
        this.license.addLicenseListener(this::licenseChanged);
    }

    private void licenseChanged(boolean isActive) {
        Platform.runLater(() -> {
            if (isActive) {
                this.mainWindow.setWindowTitle("SQLines Studio");
                this.settingsWindow.setLicenseInfo("License: Active");
            } else {
                this.mainWindow.setWindowTitle("SQLINES STUDIO - FOR EVALUATION USE ONLY");
                this.settingsWindow.setLicenseInfo("License: For evaluation use only");
            }
        });
    }

    private void initMainWindowHandlers() {
        this.mainWindow.setOnPreferencesAction(event -> this.showSettingsWindow());
        this.mainWindow.setOnCloseAction(event -> this.windows.forEach(BaseView::close));
        this.mainWindow.setOnStatusBarAction(event -> this.changeStatusBarPolicyPressed());
        this.mainWindow.setOnTargetFieldAction(event -> this.changeTargetFieldPolicyPressed());
        this.mainWindow.setOnWrappingAction(event -> this.changeWrappingPolicyPressed());
        this.mainWindow.setOnHighlighterAction(event -> this.changeHighlighterPolicePressed());
        this.mainWindow.setOnLineNumbersAction(event -> this.changeLineNumbersPolicyPressed());
    }

    private void showSettingsWindow() {
        if (!this.settingsWindow.isShowing()) {
            this.settingsWindow.show();
        } else {
            this.settingsWindow.toFront();
        }
    }

    private void changeStatusBarPolicyPressed() {
        try {
            String currentPolicy = PropertiesManager.get("SHOW_STATUS_BAR", PropertiesManager.STATUS_BAR_VALUES.SHOW);
            if (currentPolicy.equals(PropertiesManager.STATUS_BAR_VALUES.SHOW.toString())) {
                this.hideStatusBar();
                log.info("Status bar policy changed. New policy: Do not show");
            } else if (currentPolicy.equals(PropertiesManager.STATUS_BAR_VALUES.DO_NOT_SHOW.toString())) {
                this.showStatusBar();
                log.info("Status bar policy changed. New policy: Show");
            }
            PropertiesManager.saveProperties();
        }
        catch (Exception exc) {
            this.handleSettingsSaveException(exc);
        }
    }

    private void hideStatusBar() {
        PropertiesManager.set("SHOW_STATUS_BAR", PropertiesManager.STATUS_BAR_VALUES.DO_NOT_SHOW);
        this.mainWindow.setStatusBarPolicy(MainWindowSettingsView.StatusBarPolicy.DO_NOT_SHOW);
        this.settingsWindow.setStatusBarSelected(false);
    }

    private void showStatusBar() {
        PropertiesManager.set("SHOW_STATUS_BAR", PropertiesManager.STATUS_BAR_VALUES.SHOW);
        this.mainWindow.setStatusBarPolicy(MainWindowSettingsView.StatusBarPolicy.SHOW);
        this.settingsWindow.setStatusBarSelected(true);
    }

    private void handleSettingsSaveException(Exception exc) {
        String errorMsg = "An error occurred while saving the settings.\n" + exc.getMessage();
        log.error(errorMsg);
        this.settingsWindow.showError("Error", errorMsg);
    }

    private void changeTargetFieldPolicyPressed() {
        try {
            String currentPolicy = PropertiesManager.get("SHOW_TARGET_FIELD", PropertiesManager.TARGET_FIELD_VALUES.AS_NEEDED);
            if (currentPolicy.equals(PropertiesManager.TARGET_FIELD_VALUES.ALWAYS.toString())) {
                this.hideTargetField();
                log.info("Target field policy changed. New policy: As needed");
            } else if (currentPolicy.equals(PropertiesManager.TARGET_FIELD_VALUES.AS_NEEDED.toString())) {
                this.showTargetField();
                log.info("Target field policy changed. New policy: Always");
            }
            PropertiesManager.saveProperties();
        }
        catch (Exception exc) {
            this.handleSettingsSaveException(exc);
        }
    }

    private void hideTargetField() {
        PropertiesManager.set("SHOW_TARGET_FIELD", PropertiesManager.TARGET_FIELD_VALUES.AS_NEEDED);
        this.mainWindow.setTargetFieldPolicy(MainWindowSettingsView.TargetFieldPolicy.AS_NEEDED);
        this.settingsWindow.setTargetFieldSelected(false);
    }

    private void showTargetField() {
        PropertiesManager.set("SHOW_TARGET_FIELD", PropertiesManager.TARGET_FIELD_VALUES.ALWAYS);
        this.mainWindow.setTargetFieldPolicy(MainWindowSettingsView.TargetFieldPolicy.ALWAYS);
        this.settingsWindow.setTargetFieldSelected(true);
    }

    private void changeWrappingPolicyPressed() {
        try {
            String currentPolicy = PropertiesManager.get("WRAP_LINES", PropertiesManager.WRAP_LINES_VALUES.WRAP);
            if (currentPolicy.equals(PropertiesManager.WRAP_LINES_VALUES.WRAP.toString())) {
                this.disableWrapping();
                log.info("Wrapping policy changed. New policy: No wrap");
            } else if (currentPolicy.equals(PropertiesManager.WRAP_LINES_VALUES.DO_NOT_WRAP.toString())) {
                this.enableWrapping();
                log.info("Wrapping policy changed. New policy: Wrap lines");
            }
            PropertiesManager.saveProperties();
        }
        catch (Exception exc) {
            this.handleSettingsSaveException(exc);
        }
    }

    private void disableWrapping() {
        PropertiesManager.set("WRAP_LINES", PropertiesManager.WRAP_LINES_VALUES.DO_NOT_WRAP);
        this.mainWindow.setWrappingPolicy(MainWindowSettingsView.WrappingPolicy.NO_WRAP);
        this.settingsWindow.setWrappingSelected(false);
    }

    private void enableWrapping() {
        PropertiesManager.set("WRAP_LINES", PropertiesManager.WRAP_LINES_VALUES.WRAP);
        this.mainWindow.setWrappingPolicy(MainWindowSettingsView.WrappingPolicy.WRAP_LINES);
        this.settingsWindow.setWrappingSelected(true);
    }

    public void changeHighlighterPolicePressed() {
        try {
            String currentPolicy = PropertiesManager.get("HIGHLIGHTER", PropertiesManager.HIGHLIGHTER_VALUES.ENABLED);
            if (currentPolicy.equals(PropertiesManager.HIGHLIGHTER_VALUES.ENABLED.toString())) {
                this.disableHighlighter();
                log.info("Highlighter policy changed. New policy: Do not highlight");
            } else if (currentPolicy.equals(PropertiesManager.HIGHLIGHTER_VALUES.DISABLED.toString())) {
                this.enableHighlighter();
                log.info("Highlighter policy changed. New policy: Highlight");
            }
            PropertiesManager.saveProperties();
        }
        catch (Exception exc) {
            this.handleSettingsSaveException(exc);
        }
    }

    private void disableHighlighter() {
        PropertiesManager.set("HIGHLIGHTER", PropertiesManager.HIGHLIGHTER_VALUES.DISABLED);
        this.mainWindow.setHighlighterPolicy(MainWindowSettingsView.HighlighterPolicy.DO_NOT_HIGHLIGHT);
        this.settingsWindow.setHighlighterSelected(false);
    }

    private void enableHighlighter() {
        PropertiesManager.set("HIGHLIGHTER", PropertiesManager.HIGHLIGHTER_VALUES.ENABLED);
        this.mainWindow.setHighlighterPolicy(MainWindowSettingsView.HighlighterPolicy.HIGHLIGHT);
        this.settingsWindow.setHighlighterSelected(true);
    }

    private void changeLineNumbersPolicyPressed() {
        try {
            String currentPolicy = PropertiesManager.get("SHOW_LINE_NUMBERS", PropertiesManager.LINE_NUMBERS_VALUES.SHOW);
            if (currentPolicy.equals(PropertiesManager.LINE_NUMBERS_VALUES.SHOW.toString())) {
                this.hideLineNumbers();
                log.info("Line numbers area policy changed. New policy: Do not show");
            } else if (currentPolicy.equals(PropertiesManager.LINE_NUMBERS_VALUES.DO_NOT_SHOW.toString())) {
                this.showLineNumbers();
                log.info("Line numbers area policy changed. New policy: Show");
            }
            PropertiesManager.saveProperties();
        }
        catch (Exception exc) {
            this.handleSettingsSaveException(exc);
        }
    }

    private void hideLineNumbers() {
        PropertiesManager.set("SHOW_LINE_NUMBERS", PropertiesManager.LINE_NUMBERS_VALUES.DO_NOT_SHOW);
        this.mainWindow.setLineNumbersPolicy(MainWindowSettingsView.LineNumbersPolicy.DO_NOT_SHOW);
        this.settingsWindow.setLineNumbersSelected(false);
    }

    private void showLineNumbers() {
        PropertiesManager.set("SHOW_LINE_NUMBERS", PropertiesManager.LINE_NUMBERS_VALUES.SHOW);
        this.mainWindow.setLineNumbersPolicy(MainWindowSettingsView.LineNumbersPolicy.SHOW);
        this.settingsWindow.setLineNumbersSelected(true);
    }

    private void initSettingsWindowHandlers() {
        this.settingsWindow.addAppearanceChangeListener((o, old, newValue) -> this.appearanceChanged((String)newValue));
        this.settingsWindow.addDirChangeListener((o, old, newDir) -> this.workingDirChanged((String)newDir));
        this.settingsWindow.setOnAddDirAction(event -> this.addDirPressed());
        this.settingsWindow.setOnSetDefaultsAction(event -> this.setDefaultsPressed());
        this.settingsWindow.setOnChangeLicenseAction(this::changeLicensePressed);
        this.settingsWindow.setOnStatusBarAction(event -> this.changeStatusBarPolicyPressed());
        this.settingsWindow.setOnTargetFieldAction(event -> this.changeTargetFieldPolicyPressed());
        this.settingsWindow.setOnWrappingAction(event -> this.changeWrappingPolicyPressed());
        this.settingsWindow.setOnHighlighterAction(event -> this.changeHighlighterPolicePressed());
        this.settingsWindow.setOnLineNumbersAction(event -> this.changeLineNumbersPolicyPressed());
    }

    private void appearanceChanged(String newAppearance) {
        try {
            if (newAppearance.equals("Light")) {
                this.setLightAppearance();
                log.info("Appearance changed. New appearance: Light");
            } else if (newAppearance.equals("Dark")) {
                this.setDarkAppearance();
                log.info("Appearance changed. New appearance: Dark");
            }
            PropertiesManager.saveProperties();
        }
        catch (Exception exc) {
            this.handleSettingsSaveException(exc);
        }
    }

    private void setLightAppearance() {
        PropertiesManager.set("APPEARANCE", PropertiesManager.APPEARANCE_VALUES.LIGHT);
        this.settingsWindow.selectAppearance(BaseView.Appearance.LIGHT);
        this.windows.forEach(window -> window.setAppearance(BaseView.Appearance.LIGHT));
    }

    private void setDarkAppearance() {
        PropertiesManager.set("APPEARANCE", PropertiesManager.APPEARANCE_VALUES.DARK);
        this.settingsWindow.selectAppearance(BaseView.Appearance.DARK);
        this.windows.forEach(window -> window.setAppearance(BaseView.Appearance.DARK));
    }

    private void workingDirChanged(String newDir) {
        try {
            this.changeDir(newDir);
            log.info("Current working directory changed: " + newDir);
            PropertiesManager.saveProperties();
        }
        catch (Exception exc) {
            this.handleSettingsSaveException(exc);
        }
    }

    private void changeDir(String newDir) {
        PropertiesManager.set("CURR_DIR", newDir);
        this.settingsWindow.selectDirectory(newDir);
    }

    private void addDirPressed() {
        try {
            Optional<String> dir = this.settingsWindow.choseDirectoryToAdd();
            if (dir.isPresent()) {
                String dirPath = dir.get();
                this.addDir(dirPath);
                this.changeDir(dirPath);
                log.info("New directory added: " + dirPath);
                PropertiesManager.saveProperties();
            }
        }
        catch (Exception exc) {
            this.handleSettingsSaveException(exc);
        }
    }

    private void addDir(String newDir) {
        int dirsNumber = Integer.parseInt(PropertiesManager.get("DIRS_NUMBER", "0"));
        PropertiesManager.set("DIR" + dirsNumber, newDir);
        PropertiesManager.set("DIRS_NUMBER", String.valueOf(dirsNumber + 1));
        this.settingsWindow.addDirectory(newDir);
    }

    private void setDefaultsPressed() {
        try {
            PropertiesManager.setDefaults();
            this.loadProperties();
            PropertiesManager.saveProperties();
            log.info("Default settings set");
        }
        catch (Exception exc) {
            this.handleSettingsSaveException(exc);
        }
    }

    private void loadProperties() {
        try {
            this.loadWindowProperties();
            this.loadDirectories();
            this.loadAppearance();
            this.loadStatusBarSetting();
            this.loadTargetFieldSetting();
            this.loadWrappingSetting();
            this.loadHighlighterSetting();
            this.loadLineNumbersSetting();
        }
        catch (Exception exc) {
            log.error("Loading properties: " + exc.getMessage());
            PropertiesManager.setDefaults();
            this.loadProperties();
        }
    }

    private void loadWindowProperties() {
        String heightProperty = PropertiesManager.get("WINDOW_HEIGHT", "650.0");
        double height = Double.parseDouble(heightProperty);
        this.mainWindow.setHeight(height);
        String widthProperty = PropertiesManager.get("WINDOW_WIDTH", "770.0");
        double width = Double.parseDouble(widthProperty);
        this.mainWindow.setWidth(width);
        String posXProperty = PropertiesManager.get("WINDOW_X", "0.0");
        double posX = Double.parseDouble(posXProperty);
        this.mainWindow.setX(posX);
        String posYProperty = PropertiesManager.get("WINDOW_Y", "0.0");
        double posY = Double.parseDouble(posYProperty);
        this.mainWindow.setY(posY);
        String isMaximized = PropertiesManager.get("WINDOW_MAXIMIZED", PropertiesManager.MAXIMIZED_VALUES.MINIMIZED);
        if (isMaximized.equals(PropertiesManager.MAXIMIZED_VALUES.MAXIMIZED.toString())) {
            this.mainWindow.setFullScreen(true);
        } else if (isMaximized.equals(PropertiesManager.MAXIMIZED_VALUES.MINIMIZED.toString())) {
            this.mainWindow.setFullScreen(false);
        }
    }

    private void loadDirectories() {
        this.loadAllDirs();
        this.loadCurrDir();
    }

    private void loadAllDirs() {
        int dirsNumber = Integer.parseInt(PropertiesManager.get("DIRS_NUMBER", "0"));
        for (int i = 0; i < dirsNumber; ++i) {
            String dir = PropertiesManager.get("DIR" + i);
            this.settingsWindow.addDirectory(dir);
        }
    }

    private void loadCurrDir() {
        String defaultDir = PropertiesManager.get("user.home") + "/sqlines";
        String currDir = PropertiesManager.get("CURR_DIR", defaultDir);
        this.settingsWindow.selectDirectory(currDir);
    }

    private void loadAppearance() {
        String appearance = PropertiesManager.get("APPEARANCE", PropertiesManager.APPEARANCE_VALUES.LIGHT);
        if (appearance.equals(PropertiesManager.APPEARANCE_VALUES.LIGHT.toString())) {
            this.setLightAppearance();
        } else if (appearance.equals(PropertiesManager.APPEARANCE_VALUES.DARK.toString())) {
            this.setDarkAppearance();
        }
    }

    private void loadStatusBarSetting() {
        String showStatusBar = PropertiesManager.get("SHOW_STATUS_BAR", PropertiesManager.STATUS_BAR_VALUES.SHOW);
        if (showStatusBar.equals(PropertiesManager.STATUS_BAR_VALUES.SHOW.toString())) {
            this.showStatusBar();
        } else if (showStatusBar.equals(PropertiesManager.STATUS_BAR_VALUES.DO_NOT_SHOW.toString())) {
            this.hideStatusBar();
        }
    }

    private void loadTargetFieldSetting() {
        String showTargetField = PropertiesManager.get("SHOW_TARGET_FIELD", PropertiesManager.TARGET_FIELD_VALUES.AS_NEEDED);
        if (showTargetField.equals(PropertiesManager.TARGET_FIELD_VALUES.ALWAYS.toString())) {
            this.showTargetField();
        } else if (showTargetField.equals(PropertiesManager.TARGET_FIELD_VALUES.AS_NEEDED.toString())) {
            this.hideTargetField();
        }
    }

    private void loadWrappingSetting() {
        String enableWrapping = PropertiesManager.get("WRAP_LINES", PropertiesManager.WRAP_LINES_VALUES.WRAP);
        if (enableWrapping.equals(PropertiesManager.WRAP_LINES_VALUES.WRAP.toString())) {
            this.enableWrapping();
        } else if (enableWrapping.equals(PropertiesManager.WRAP_LINES_VALUES.DO_NOT_WRAP.toString())) {
            this.disableWrapping();
        }
    }

    private void loadHighlighterSetting() {
        String enableHighlighter = PropertiesManager.get("HIGHLIGHTER", PropertiesManager.HIGHLIGHTER_VALUES.ENABLED);
        if (enableHighlighter.equals(PropertiesManager.HIGHLIGHTER_VALUES.ENABLED.toString())) {
            this.enableHighlighter();
        } else if (enableHighlighter.equals(PropertiesManager.HIGHLIGHTER_VALUES.DISABLED.toString())) {
            this.disableHighlighter();
        }
    }

    private void loadLineNumbersSetting() {
        String lineNumbersProperty = PropertiesManager.get("SHOW_LINE_NUMBERS", PropertiesManager.LINE_NUMBERS_VALUES.SHOW);
        if (lineNumbersProperty.equals(PropertiesManager.LINE_NUMBERS_VALUES.SHOW.toString())) {
            this.showLineNumbers();
        } else if (lineNumbersProperty.equals(PropertiesManager.LINE_NUMBERS_VALUES.DO_NOT_SHOW.toString())) {
            this.hideLineNumbers();
        }
    }

    private void changeLicensePressed(ChangeLicenseEvent event) {
        try {
            this.license.changeLicense(event.getRegName(), event.getRegNumber());
            log.info("License status changed");
        }
        catch (Exception exc) {
            String errorMsg = "Change license status: " + exc.getMessage();
            log.info(errorMsg);
            this.settingsWindow.showError("Error", errorMsg);
        }
    }

    private void checkLicense() {
        try {
            if (this.license.isActive()) {
                this.showActiveLicense();
            } else {
                this.showNotActiveLicense();
            }
        }
        catch (Exception exc) {
            this.showNotActiveLicense();
            log.error("License check: " + exc.getMessage());
        }
    }

    private void showActiveLicense() {
        this.mainWindow.setWindowTitle("SQLines Studio");
        this.settingsWindow.setLicenseInfo("License: Active");
    }

    private void showNotActiveLicense() {
        this.mainWindow.setWindowTitle("SQLINES STUDIO - FOR EVALUATION USE ONLY");
        this.settingsWindow.setLicenseInfo("License: For evaluation use only");
    }
}

