/*
 * Decompiled with CFR 0.152.
 */
package com.sqlines.studio.util.file;

import com.sqlines.studio.util.file.FileCreator;
import com.sqlines.studio.util.file.FileDeleter;
import com.sqlines.studio.util.file.FileReader;
import com.sqlines.studio.util.file.FileStatsProvider;
import com.sqlines.studio.util.file.FileWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;

public class FileCommons
implements FileReader,
FileWriter,
FileCreator,
FileDeleter,
FileStatsProvider {
    @Override
    public String read(String path) throws IOException {
        File file = new File(path);
        try (FileInputStream stream = new FileInputStream(file);){
            String string = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
            return string;
        }
    }

    @Override
    public void write(String path, String data) throws IOException {
        File file = new File(path);
        try (FileOutputStream stream = new FileOutputStream(file);){
            stream.write(data.getBytes());
        }
    }

    @Override
    public void createFile(String path) throws IOException {
        File file = new File(path);
        if (!file.createNewFile()) {
            String errorMsg = "Cannot create file: " + file.getAbsolutePath();
            throw new IOException(errorMsg);
        }
    }

    @Override
    public String createTmpFile(String name) throws IOException {
        File file = File.createTempFile(name, ".tmp");
        return file.getAbsolutePath();
    }

    @Override
    public void delete(String path) throws IOException {
        Files.delete(Path.of(path, new String[0]));
    }

    @Override
    public boolean exists(String path) {
        return new File(path).exists();
    }

    @Override
    public long lastModified(String path) {
        return new File(path).lastModified();
    }

    @Override
    public String directory(String path) {
        return new File(path).getParentFile().getAbsolutePath();
    }
}

