/*
 * Decompiled with CFR 0.152.
 */
package com.sqlines.studio.view.mainwindow;

import com.sqlines.studio.resource.UIResource;
import com.sqlines.studio.view.AbstractWindow;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.stage.Modality;
import javafx.stage.StageStyle;

public class AboutWindow
extends AbstractWindow {
    public AboutWindow(UIResource sqlinesIcon) {
        this.setUpScene(sqlinesIcon.getUrl());
        this.setUpWindow();
    }

    private void setUpScene(String sqlinesIcon) {
        ImageView logoImg = this.createLogoImage(sqlinesIcon);
        Parent appInfo = this.createAppInfo();
        Parent layout = this.createMainLayout(logoImg, appInfo);
        this.setRoot(layout);
    }

    private ImageView createLogoImage(String sqlinesIcon) {
        ImageView logoImg = new ImageView(new Image(sqlinesIcon));
        logoImg.setFitHeight(115.0);
        logoImg.setFitWidth(110.0);
        return logoImg;
    }

    private Parent createAppInfo() {
        Text appInfo = new Text("SQLines Studio\n  Version: 3.0");
        Text copyrightInfo = new Text("\u00a9 2021 SQLines\nAll rights reserved");
        VBox infoLayout = new VBox(appInfo, copyrightInfo);
        infoLayout.setAlignment(Pos.CENTER);
        infoLayout.setSpacing(5.0);
        return infoLayout;
    }

    private Parent createMainLayout(Node logo, Node appInfo) {
        VBox mainLayout = new VBox(logo, appInfo);
        mainLayout.setId("aboutWindow");
        mainLayout.setSpacing(10.0);
        mainLayout.setAlignment(Pos.CENTER);
        mainLayout.setPadding(new Insets(50.0, 0.0, 60.0, 0.0));
        return mainLayout;
    }

    private void setUpWindow() {
        this.initModality(Modality.APPLICATION_MODAL);
        this.initStyle(StageStyle.UTILITY);
        this.setTitle("About SQLines Studio");
        this.setHeight(240.0);
        this.setWidth(230.0);
        this.setResizable(false);
    }
}

