/*
 * Decompiled with CFR 0.152.
 */
package com.sqlines.studio.view.mainwindow;

import com.sqlines.studio.view.mainwindow.event.RecentFileEvent;
import de.jangassen.MenuToolkit;
import java.util.Collection;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;

public class MainMenuBar
extends MenuBar {
    private EventHandler<RecentFileEvent> recentFileEventHandler;
    private final MenuItem aboutMenuItem = new MenuItem();
    private final MenuItem preferencesMenuItem = new MenuItem();
    private final MenuItem newTabMenuItem = new MenuItem();
    private final MenuItem closeTabMenuItem = new MenuItem();
    private final MenuItem nextTabMenuItem = new MenuItem();
    private final MenuItem prevTabMenuItem = new MenuItem();
    private final MenuItem openFileMenuItem = new MenuItem();
    private final MenuItem saveFileMenuItem = new MenuItem();
    private final MenuItem saveFileAsMenuItem = new MenuItem();
    private final MenuItem clearRecentMenuItem = new MenuItem();
    private final Menu openRecentMenu = new Menu();
    private final MenuItem undoMenuItem = new MenuItem();
    private final MenuItem redoMenuItem = new MenuItem();
    private final MenuItem selectAllMenuItem = new MenuItem();
    private final MenuItem cutMenuItem = new MenuItem();
    private final MenuItem copyMenuItem = new MenuItem();
    private final MenuItem pasteMenuItem = new MenuItem();
    private final MenuItem zoomInMenuItem = new MenuItem();
    private final MenuItem zoomOutMenuItem = new MenuItem();
    private final CheckMenuItem statusBarMenuItem = new CheckMenuItem();
    private final CheckMenuItem targetFieldMenuItem = new CheckMenuItem();
    private final CheckMenuItem wrappingMenuItem = new CheckMenuItem();
    private final CheckMenuItem highlighterMenuItem = new CheckMenuItem();
    private final CheckMenuItem lineNumbersMenuItem = new CheckMenuItem();
    private final MenuItem runMenuItem = new MenuItem();
    private final MenuItem onlineHelpMenuItem = new MenuItem();
    private final MenuItem openSiteMenuItem = new MenuItem();

    public MainMenuBar() {
        this.makeMainMenu();
        this.makeFileMenu();
        this.makeEditMenu();
        this.makeViewMenu();
        this.makeToolsMenu();
        this.makeHelpMenu();
    }

    private void makeMainMenu() {
        boolean osIsMac = System.getProperty("os.name").toLowerCase().startsWith("mac");
        if (osIsMac) {
            this.setUpMainMenuItems();
            this.makeMacOsMainMenu();
        }
    }

    private void setUpMainMenuItems() {
        this.aboutMenuItem.setText("About SQLines Studio...");
        this.preferencesMenuItem.setText("Preferences...");
    }

    private void makeMacOsMainMenu() {
        this.useSystemMenuBarProperty().set(true);
        MenuToolkit toolkit = MenuToolkit.toolkit();
        Menu defaultMenu = toolkit.createDefaultApplicationMenu("SQLines Studio");
        defaultMenu.getItems().set(0, this.aboutMenuItem);
        defaultMenu.getItems().set(1, this.preferencesMenuItem);
        defaultMenu.getItems().add(2, new SeparatorMenuItem());
        toolkit.setApplicationMenu(defaultMenu);
        toolkit.setMenuBar(this);
    }

    private void makeFileMenu() {
        this.setUpFileMenuItems();
        Menu fileMenu = new Menu("File");
        fileMenu.getItems().addAll((MenuItem[])new MenuItem[]{this.newTabMenuItem, this.closeTabMenuItem, this.nextTabMenuItem, this.prevTabMenuItem, new SeparatorMenuItem(), this.openFileMenuItem, this.openRecentMenu, this.saveFileMenuItem, this.saveFileAsMenuItem});
        this.getMenus().add(fileMenu);
    }

    private void setUpFileMenuItems() {
        this.newTabMenuItem.setText("New Tab");
        this.newTabMenuItem.setAccelerator(new KeyCodeCombination(KeyCode.T, KeyCombination.SHORTCUT_DOWN));
        this.closeTabMenuItem.setText("Close Tab");
        this.closeTabMenuItem.setAccelerator(new KeyCodeCombination(KeyCode.W, KeyCombination.SHORTCUT_DOWN));
        this.nextTabMenuItem.setText("Next Tab");
        this.nextTabMenuItem.setAccelerator(new KeyCodeCombination(KeyCode.RIGHT, KeyCombination.SHORTCUT_DOWN));
        this.prevTabMenuItem.setText("Previous Tab");
        this.prevTabMenuItem.setAccelerator(new KeyCodeCombination(KeyCode.LEFT, KeyCombination.SHORTCUT_DOWN));
        this.openFileMenuItem.setText("Open File...");
        this.openFileMenuItem.setAccelerator(new KeyCodeCombination(KeyCode.O, KeyCombination.SHORTCUT_DOWN));
        this.clearRecentMenuItem.setText("Clear");
        this.openRecentMenu.setText("Open Recent");
        this.openRecentMenu.getItems().add(new SeparatorMenuItem());
        this.openRecentMenu.getItems().add(this.clearRecentMenuItem);
        this.saveFileMenuItem.setText("Save File");
        this.saveFileMenuItem.setAccelerator(new KeyCodeCombination(KeyCode.S, KeyCombination.SHORTCUT_DOWN));
        this.saveFileAsMenuItem.setText("Save File As...");
        this.saveFileAsMenuItem.setAccelerator(new KeyCodeCombination(KeyCode.S, KeyCombination.SHORTCUT_DOWN, KeyCombination.SHIFT_DOWN));
    }

    private void makeEditMenu() {
        this.setUpEditMenuItems();
        Menu editMenu = new Menu("Edit");
        editMenu.getItems().addAll((MenuItem[])new MenuItem[]{this.undoMenuItem, this.redoMenuItem, new SeparatorMenuItem(), this.selectAllMenuItem, this.cutMenuItem, this.copyMenuItem, this.pasteMenuItem});
        this.getMenus().add(editMenu);
    }

    private void setUpEditMenuItems() {
        this.undoMenuItem.setText("Undo");
        this.redoMenuItem.setText("Redo");
        this.selectAllMenuItem.setText("Select All");
        this.cutMenuItem.setText("Cut");
        this.copyMenuItem.setText("Copy");
        this.pasteMenuItem.setText("Paste");
    }

    private void makeViewMenu() {
        this.setUpViewMenuItems();
        Menu editorMenu = new Menu("Editor");
        editorMenu.getItems().addAll((MenuItem[])new MenuItem[]{this.wrappingMenuItem, this.highlighterMenuItem, this.lineNumbersMenuItem});
        Menu viewMenu = new Menu("View");
        viewMenu.getItems().addAll((MenuItem[])new MenuItem[]{this.zoomInMenuItem, this.zoomOutMenuItem, new SeparatorMenuItem(), this.statusBarMenuItem, this.targetFieldMenuItem, new SeparatorMenuItem(), editorMenu});
        this.getMenus().add(viewMenu);
    }

    private void setUpViewMenuItems() {
        this.zoomInMenuItem.setText("Zoom In");
        this.zoomInMenuItem.setAccelerator(new KeyCodeCombination(KeyCode.A, KeyCombination.SHIFT_DOWN, KeyCombination.SHORTCUT_DOWN));
        this.zoomOutMenuItem.setText("Zoom Out");
        this.zoomOutMenuItem.setAccelerator(new KeyCodeCombination(KeyCode.E, KeyCombination.SHIFT_DOWN, KeyCombination.SHORTCUT_DOWN));
        this.statusBarMenuItem.setText("Show Status Bar");
        this.targetFieldMenuItem.setText("Always Show Target Field");
        this.wrappingMenuItem.setText("Wrap Lines To Editor Width");
        this.highlighterMenuItem.setText("Highlighter");
        this.lineNumbersMenuItem.setText("Line Numbers");
    }

    private void makeToolsMenu() {
        this.setUpToolsMenuItems();
        Menu toolsMenu = new Menu("Tools");
        boolean osIsWin = System.getProperty("os.name").toLowerCase().startsWith("win");
        if (osIsWin) {
            this.preferencesMenuItem.setText("Settings");
            toolsMenu.getItems().addAll((MenuItem[])new MenuItem[]{this.preferencesMenuItem, new SeparatorMenuItem()});
        }
        toolsMenu.getItems().add(this.runMenuItem);
        this.getMenus().add(toolsMenu);
    }

    private void setUpToolsMenuItems() {
        this.runMenuItem.setText("Run Conversion");
        this.runMenuItem.setAccelerator(new KeyCodeCombination(KeyCode.R, KeyCombination.SHORTCUT_DOWN));
    }

    private void makeHelpMenu() {
        this.setUpHelpMenuItems();
        Menu helpMenu = new Menu("Help");
        helpMenu.getItems().addAll((MenuItem[])new MenuItem[]{this.onlineHelpMenuItem, this.openSiteMenuItem});
        this.getMenus().add(helpMenu);
    }

    private void setUpHelpMenuItems() {
        this.onlineHelpMenuItem.setText("Online Help...");
        this.openSiteMenuItem.setText("Official Site...");
    }

    public void addRecentFile(String filePath) {
        if (filePath.isEmpty()) {
            throw new IllegalArgumentException("File path is empty");
        }
        MenuItem newFile = new MenuItem(filePath);
        newFile.setOnAction(event -> this.setUpRecentFileEventHandler(newFile));
        this.openRecentMenu.getItems().add(0, newFile);
    }

    private void setUpRecentFileEventHandler(MenuItem item) {
        RecentFileEvent recentFileEvent = new RecentFileEvent(item.getText());
        this.fireEvent(recentFileEvent);
        if (this.recentFileEventHandler != null) {
            this.recentFileEventHandler.handle(recentFileEvent);
        }
    }

    public void clearRecentFiles() {
        ObservableList<MenuItem> items = this.openRecentMenu.getItems();
        items.removeIf(item -> items.size() != 2);
    }

    public void moveRecentFile(String filePath, int moveTo) {
        ObservableList<MenuItem> files = this.openRecentMenu.getItems();
        this.checkBounds(moveTo, 0, files.size());
        MenuItem recentFile = this.findRecentFile(files, filePath);
        files.remove(recentFile);
        files.add(moveTo, recentFile);
    }

    private void checkBounds(int moveTo, int boundFrom, int boundTo) {
        if (moveTo < boundFrom || moveTo >= boundTo) {
            String errorMsg = "Index is out of range: (" + boundFrom + ":" + boundTo + ") expected, " + moveTo + " provided";
            throw new IndexOutOfBoundsException(errorMsg);
        }
    }

    private MenuItem findRecentFile(Collection<MenuItem> files, String title) {
        return files.stream().filter(menuItem -> menuItem.getText().equals(title)).findFirst().orElseThrow(() -> new IllegalArgumentException("No such recent file exists: " + title));
    }

    public void setStatusBarSelected(boolean isSelected) {
        this.statusBarMenuItem.setSelected(isSelected);
    }

    public void setTargetFieldSelected(boolean isSelected) {
        this.targetFieldMenuItem.setSelected(isSelected);
    }

    public void setWrappingSelected(boolean isSelected) {
        this.wrappingMenuItem.setSelected(isSelected);
    }

    public void setHighlighterSelected(boolean isSelected) {
        this.highlighterMenuItem.setSelected(isSelected);
    }

    public void setLineNumbersSelected(boolean isSelected) {
        this.lineNumbersMenuItem.setSelected(isSelected);
    }

    public void setCloseTabState(boolean isEnabled) {
        this.closeTabMenuItem.setDisable(!isEnabled);
    }

    public void setNextTabState(boolean isEnabled) {
        this.nextTabMenuItem.setDisable(!isEnabled);
    }

    public void setPrevTabState(boolean isEnabled) {
        this.prevTabMenuItem.setDisable(!isEnabled);
    }

    public void setOpenRecentState(boolean isEnabled) {
        this.openRecentMenu.setDisable(!isEnabled);
    }

    public void setUndoState(boolean isEnabled) {
        this.undoMenuItem.setDisable(!isEnabled);
    }

    public void setRedoState(boolean isEnabled) {
        this.redoMenuItem.setDisable(!isEnabled);
    }

    public void setOnAboutAction(EventHandler<ActionEvent> action) {
        this.aboutMenuItem.setOnAction(action);
    }

    public void setOnPreferencesAction(EventHandler<ActionEvent> action) {
        this.preferencesMenuItem.setOnAction(action);
    }

    public void setOnNewTabAction(EventHandler<ActionEvent> action) {
        this.newTabMenuItem.setOnAction(action);
    }

    public void setOnCloseTabAction(EventHandler<ActionEvent> action) {
        this.closeTabMenuItem.setOnAction(action);
    }

    public void setOnNextTabAction(EventHandler<ActionEvent> action) {
        this.nextTabMenuItem.setOnAction(action);
    }

    public void setOnPrevTabAction(EventHandler<ActionEvent> action) {
        this.prevTabMenuItem.setOnAction(action);
    }

    public void setOnOpenFileAction(EventHandler<ActionEvent> action) {
        this.openFileMenuItem.setOnAction(action);
    }

    public void setOnOpenRecentAction(EventHandler<RecentFileEvent> action) {
        this.recentFileEventHandler = action;
    }

    public void setOnClearRecentAction(EventHandler<ActionEvent> action) {
        this.clearRecentMenuItem.setOnAction(action);
    }

    public void setOnSaveFileAction(EventHandler<ActionEvent> action) {
        this.saveFileMenuItem.setOnAction(action);
    }

    public void setOnSaveAsAction(EventHandler<ActionEvent> action) {
        this.saveFileAsMenuItem.setOnAction(action);
    }

    public void setOnUndoAction(EventHandler<ActionEvent> action) {
        this.undoMenuItem.setOnAction(action);
    }

    public void setOnRedoAction(EventHandler<ActionEvent> action) {
        this.redoMenuItem.setOnAction(action);
    }

    public void setOnSelectAllAction(EventHandler<ActionEvent> action) {
        this.selectAllMenuItem.setOnAction(action);
    }

    public void setOnCutAction(EventHandler<ActionEvent> action) {
        this.cutMenuItem.setOnAction(action);
    }

    public void setOnCopyAction(EventHandler<ActionEvent> action) {
        this.copyMenuItem.setOnAction(action);
    }

    public void setOnPasteAction(EventHandler<ActionEvent> action) {
        this.pasteMenuItem.setOnAction(action);
    }

    public void setOnZoomInAction(EventHandler<ActionEvent> action) {
        this.zoomInMenuItem.setOnAction(action);
    }

    public void setOnZoomOutAction(EventHandler<ActionEvent> action) {
        this.zoomOutMenuItem.setOnAction(action);
    }

    public void setOnStatusBarAction(EventHandler<ActionEvent> action) {
        this.statusBarMenuItem.setOnAction(action);
    }

    public void setOnTargetFieldAction(EventHandler<ActionEvent> action) {
        this.targetFieldMenuItem.setOnAction(action);
    }

    public void setOnWrappingAction(EventHandler<ActionEvent> action) {
        this.wrappingMenuItem.setOnAction(action);
    }

    public void setOnHighlighterAction(EventHandler<ActionEvent> action) {
        this.highlighterMenuItem.setOnAction(action);
    }

    public void setOnLineNumbersAction(EventHandler<ActionEvent> action) {
        this.lineNumbersMenuItem.setOnAction(action);
    }

    public void setOnRunAction(EventHandler<ActionEvent> action) {
        this.runMenuItem.setOnAction(action);
    }

    public void setOnOnlineHelpAction(EventHandler<ActionEvent> action) {
        this.onlineHelpMenuItem.setOnAction(action);
    }

    public void setOnOpenSiteAction(EventHandler<ActionEvent> action) {
        this.openSiteMenuItem.setOnAction(action);
    }
}

