/*
 * Decompiled with CFR 0.152.
 */
package com.sqlines.studio.view.mainwindow.editor;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;

public class EditorContextMenu
extends ContextMenu {
    private final MenuItem undoMenuItem = new MenuItem();
    private final MenuItem redoMenuItem = new MenuItem();
    private final MenuItem selectAllMenuItem = new MenuItem();
    private final MenuItem cutMenuItem = new MenuItem();
    private final MenuItem copyMenuItem = new MenuItem();
    private final MenuItem pasteMenuItem = new MenuItem();

    public EditorContextMenu() {
        this.setUpMenuItems();
        this.setUpLayout();
    }

    private void setUpMenuItems() {
        this.undoMenuItem.setText("Undo");
        this.redoMenuItem.setText("Redo");
        this.selectAllMenuItem.setText("Select All");
        this.cutMenuItem.setText("Cut");
        this.copyMenuItem.setText("Copy");
        this.pasteMenuItem.setText("Paste");
    }

    private void setUpLayout() {
        this.getItems().addAll((MenuItem[])new MenuItem[]{this.undoMenuItem, this.redoMenuItem, new SeparatorMenuItem(), this.selectAllMenuItem, this.cutMenuItem, this.copyMenuItem, this.pasteMenuItem});
    }

    public void setUndoEnabled(boolean isEnabled) {
        this.undoMenuItem.setDisable(!isEnabled);
    }

    public void setRedoEnabled(boolean isEnabled) {
        this.redoMenuItem.setDisable(!isEnabled);
    }

    public void setOnUndoAction(EventHandler<ActionEvent> action) {
        this.undoMenuItem.setOnAction(action);
    }

    public void setOnRedoAction(EventHandler<ActionEvent> action) {
        this.redoMenuItem.setOnAction(action);
    }

    public void setOnSelectAllAction(EventHandler<ActionEvent> action) {
        this.selectAllMenuItem.setOnAction(action);
    }

    public void setOnCutAction(EventHandler<ActionEvent> action) {
        this.cutMenuItem.setOnAction(action);
    }

    public void setOnCopyAction(EventHandler<ActionEvent> action) {
        this.copyMenuItem.setOnAction(action);
    }

    public void setOnPasteAction(EventHandler<ActionEvent> action) {
        this.pasteMenuItem.setOnAction(action);
    }
}

