/*
 * Decompiled with CFR 0.152.
 */
package com.sqlines.studio.view.mainwindow.editor;

import java.util.function.Consumer;
import java.util.function.Function;
import javafx.application.Platform;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.StyleSpans;
import org.reactfx.collection.ListModification;

class VisibleParagraphStyler<PS, SEG, S>
implements Consumer<ListModification<? extends Paragraph<PS, SEG, S>>> {
    private final GenericStyledArea<PS, SEG, S> area;
    private final Function<String, StyleSpans<S>> computeStyles;
    private int prevParagraph;
    private int prevTextLength;

    public VisibleParagraphStyler(GenericStyledArea<PS, SEG, S> area, Function<String, StyleSpans<S>> computeStyles) {
        this.computeStyles = computeStyles;
        this.area = area;
    }

    @Override
    public void accept(ListModification<? extends Paragraph<PS, SEG, S>> modification) {
        if (modification.getAddedSize() > 0) {
            int paragraph = Math.min(this.area.firstVisibleParToAllParIndex() + modification.getFrom(), this.area.getParagraphs().size() - 1);
            String text = this.area.getText(paragraph, 0, paragraph, this.area.getParagraphLength(paragraph));
            if (paragraph != this.prevParagraph || text.length() != this.prevTextLength) {
                int startPos = this.area.getAbsolutePosition(paragraph, 0);
                Platform.runLater(() -> this.area.setStyleSpans(startPos, this.computeStyles.apply(text)));
                this.prevTextLength = text.length();
                this.prevParagraph = paragraph;
            }
        }
    }
}

