/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.collection;

import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import org.reactfx.collection.ListChange;
import org.reactfx.collection.ListChangeAccumulator;
import org.reactfx.collection.ListModificationSequence;
import org.reactfx.collection.QuasiListChangeImpl;
import org.reactfx.collection.QuasiListModification;
import org.reactfx.util.Lists;

public interface QuasiListChange<E>
extends ListModificationSequence<E> {
    @Override
    default public QuasiListChange<E> asListChange() {
        return this;
    }

    @Override
    default public ListChangeAccumulator<E> asListChangeAccumulator() {
        return new ListChangeAccumulator(this);
    }

    public static <E> QuasiListChange<E> safeCast(QuasiListChange<? extends E> mod) {
        return mod;
    }

    public static <E> QuasiListChange<E> from(ListChangeListener.Change<? extends E> ch) {
        QuasiListChangeImpl res = new QuasiListChangeImpl();
        while (ch.next()) {
            res.add(QuasiListModification.fromCurrentStateOf(ch));
        }
        return res;
    }

    public static <E> ListChange<E> instantiate(QuasiListChange<? extends E> change, ObservableList<E> list) {
        return () -> Lists.mappedView(change.getModifications(), mod -> QuasiListModification.instantiate(mod, list));
    }
}

